from .model import BaseVisitor


class UpstreamChecker(BaseVisitor):
    RULE = 'UNISTAT_DISABLED'

    def check_InstanceMacro(self, module, path):
        is_unistat_enabled = module.unistat
        if not is_unistat_enabled:
            self.warn(path, 'UNISTAT_DISABLED', severity=3, tags={'total'})

    def check_L7Macro(self, module, path):
        is_unistat_disabled = module.compat and module.compat.pb.disable_unistat
        if is_unistat_disabled:
            self.warn(path, 'UNISTAT_DISABLED', severity=3, tags={'total'})
