import collections
import json
import six


with open('./certs-index.json') as f:
    data = json.load(f)

inverse = collections.defaultdict(set)
for namespace_id, certs in six.iteritems(data):
    for cert in certs:
        inverse[str(cert)].add(namespace_id)


def create_awacs_namespace_href(namespace_id):
    return 'https://nanny.yandex-team.ru/ui/#/awacs/namespaces/list/{0}/show/'.format(
        namespace_id)


for c, namespace_ids in six.iteritems(inverse):
    if not c:
        continue
    if len(namespace_ids) > 1:
        for namespace_id in namespace_ids:
            print(namespace_id)
        continue
    if len(namespace_ids) > 1:
        print('secret {} is shared by'.format(c))
        for namespace_id in namespace_ids:
            print(' *', create_awacs_namespace_href(namespace_id))
        print()
