from datetime import datetime
import six


def list_namespace_ids_with_yp_lite_balancers(app, namespace_id_in=()):
    """
    :type app: infra.awacs.tools.awacstoolslib.app.App
    """
    rv = set()
    for aspects_set in app.awacs_client.iter_all_balancer_aspects_sets(namespace_id_in=namespace_id_in):
        namespace_id = aspects_set.meta.namespace_id
        content_pb = aspects_set.content.cluster.content
        if not content_pb.active_conf_id:
            continue
        if content_pb.platform == content_pb.YP_LITE:
            rv.add(namespace_id)
    return rv


def list_namespace_ids_with_quickstart_balancers(app, namespace_id_in=()):
    """
    :type app: infra.awacs.tools.awacstoolslib.app.App
    """
    rv = set()
    for balancer_pb in app.awacs_client.iter_all_balancers():
        if balancer_pb.spec.yandex_balancer.mode == balancer_pb.spec.yandex_balancer.QUICK_START_MODE:
            namespace_id = balancer_pb.meta.namespace_id
            rv.add(namespace_id)
    return rv


def list_namespace_ids_with_large_rps(app, threshold):
    """
    :type app: infra.awacs.tools.awacstoolslib.app.App
    :type threshold: int
    """
    rv = set()
    for namespace_id, rps in app.awacs_client.get_yesterday_max_rps_stats_by_namespace().items():
        if rps >= threshold:
            rv.add(namespace_id)
    return rv


def find_pie_by_id(pie_pbs, id):
    for pie_pb in pie_pbs:
        if pie_pb.id == id:
            return pie_pb


def pie_to_sum(pie):
    rv = 0
    for k, v in six.iteritems(pie.slices):
        rv += int(k) * v
    return rv


def find_pie_sum_by_id(balancer_pies, pie_name):
    pie = find_pie_by_id(balancer_pies, pie_name)
    if pie is not None:
        return pie_to_sum(pie)
    else:
        return 0


def list_namespace_ids_w_sd(app):
    """
    :type app: infra.awacs.tools.awacstoolslib.app.App
    """
    rv = set()

    dt = datetime.utcnow().replace(hour=0, minute=0, second=0, microsecond=0)
    date_statistics_pb = app.awacs_client.get_usage_statistics_entry(dt).date_statistics
    for n_id, n_pb in sorted(date_statistics_pb.by_namespace.items()):
        yp_endpoint_sets_sd_backends_count = find_pie_sum_by_id(n_pb.balancer_pies, 'sd_backends_count')
        if yp_endpoint_sets_sd_backends_count > 0:
            rv.add(n_id)

    return rv


def list_namespace_ids_w_yp_es(app):
    """
    :type app: infra.awacs.tools.awacstoolslib.app.App
    """
    rv = set()

    dt = datetime.utcnow().replace(hour=0, minute=0, second=0, microsecond=0)
    date_statistics_pb = app.awacs_client.get_usage_statistics_entry(dt).date_statistics
    for n_id, n_pb in sorted(date_statistics_pb.by_namespace.items()):
        yp_endpoint_sets_backends_count = find_pie_sum_by_id(n_pb.balancer_pies, 'yp_endpoint_sets_backends_count')
        yp_endpoint_sets_sd_backends_count = find_pie_sum_by_id(n_pb.balancer_pies, 'sd_backends_count')
        if (find_pie_sum_by_id(n_pb.balancer_pies, 'nanny_snapshots_backends_count') +
            find_pie_sum_by_id(n_pb.balancer_pies, 'gencfg_groups_backends_count') +
            find_pie_sum_by_id(n_pb.balancer_pies, 'manual_backends_count')):
            continue
        if yp_endpoint_sets_backends_count > 0 and yp_endpoint_sets_backends_count != yp_endpoint_sets_sd_backends_count:
            rv.add(n_id)

    return rv
