#include <library/cpp/regex/pire/pire.h>
#include <iostream>
#include <string.h>
#include <vector>
#include <stdio.h>

Pire::Fsm ParseRegexp(const char* pattern, bool surround, bool caseInsensitive)
{
    std::vector<wchar32> ucs4;
    Pire::Encodings::Utf8().FromLocal(pattern, pattern + strlen(pattern), std::back_inserter(ucs4));
    Pire::Lexer lexer(ucs4.begin(), ucs4.end());
    lexer.SetEncoding(Pire::Encodings::Utf8());
    if (caseInsensitive) {
        lexer.AddFeature(Pire::Features::CaseInsensitive());
    }
    auto fsm = lexer.Parse();
    if (surround) {
         fsm.Surround();
    }
    return fsm;
}

const char* Dump(Pire::Fsm& fsm)
{
    TStringStream data;
    fsm.DumpTo(data);
    TString s = data.Data();
    return s.data();
}

bool DoIntersect(Pire::Fsm& fsm1, Pire::Fsm& fsm2)
{
     auto fsm = fsm1 & fsm2;
     fsm.Canonize();
     Pire::Scanner scanner = fsm.Compile<Pire::Scanner>();
     typename Pire::Scanner::State state;
     scanner.Initialize(state);
     return fsm.Size() != 1 && !scanner.Final(state);
}

bool ContainsBeginMark(Pire::Fsm& fsm)
{
    for (Pire::Fsm::LettersTbl::ConstIterator lit = fsm.Letters().Begin(), lie = fsm.Letters().End(); lit != lie; ++lit) {
        if (lit->first == Pire::SpecialChar::BeginMark) {
            return true;
        }
    }
    return false;
}

bool ContainsEndMark(Pire::Fsm& fsm)
{
    for (Pire::Fsm::LettersTbl::ConstIterator lit = fsm.Letters().Begin(), lie = fsm.Letters().End(); lit != lie; ++lit) {
        if (lit->first == Pire::SpecialChar::EndMark) {
            return true;
        }
    }
    return false;
}
