import time

import pire


def test_pire():
    pairs = [
                ('.*test[\\.-]gobabygo2.n.yandex-team.ru:(\d+)?', 'b.*test[\\.-]gobabygo2.n.yandex-team.ru:a(\d+)?'),
                ('.*[a-b]test[\\.-]gobabygo2.n.yandex-team.ru:(\d+)?',
                 '.*ztest[\\.-]gobabygo2.n.yandex-team.ru:a(\d+)+'),
            ] * 300 + [
                ('a', '.*a'),
            ]
    fsms = {}
    for x, y in pairs:
        for z in (x, y):
            if z not in fsms:
                fsms[(z, False, True)] = pire.parse_regexp(z)
    pairs = [
        ((x, False, True), (y, False, True)) for x, y in pairs
    ]
    b = time.time()
    print((pire.get_first_intersection_idx(pairs, fsms)))
    a = time.time()
    print((a - b))
