# coding: utf-8
import socket

from sepelib.core import config
from sepelib.flask.h.error_handlers import register_error_handlers

from awacs import version
from awacs.model import storage_modern
from awacs.web.app import create_app
from awacs.web.server import AwacsWebServer
from .base import ApplicationBase


class Application(ApplicationBase):
    name = 'awacsd'

    ENABLE_CACHE_EXTENDED_SIGNALS = True

    def __init__(self, instance_id):
        super(Application, self).__init__(instance_id, cache_structure=storage_modern.construct_full_zk_structure())
        webapp = self.init_web_application(
            name=self.name,
            debug=config.get_value('run.debug', False),
            production=config.get_value('run.production', False),
            sentry_client=self.sentry_client
        )
        register_error_handlers(webapp)
        if config.get_value('run.debug', False) and not config.get_value('run.production', True):
            certfile = config.get_value('web.certfile', None)
        else:
            certfile = None
        self.web = AwacsWebServer(config.get(), webapp,
                                  version=version.VERSION,
                                  instance_id=instance_id,
                                  certfile=certfile)

    @staticmethod
    def init_web_application(name, debug=False, production=False, sentry_client=None):
        return create_app(name,
                          socket.gethostname(),
                          version=version.VERSION,
                          version_timestamp=version.TIMESTAMP,
                          debug=debug,
                          production=production,
                          sentry_client=sentry_client)

    def run(self):
        super(Application, self).run()
        self.web.run()

    def term(self, *args, **kwargs):
        self.web.stop()

    def stop(self):
        self.web.stop()
        super(Application, self).stop()
