try:
    from six.moves import copyreg
    import argparse

    from infra.swatlib import cmdutil
    from awacs.app import awacsd
    from awacs.version import VERSION
except KeyboardInterrupt:
    # don't bother user with python stack trace
    # if interrupted (by Ctrl+C) during imports
    raise SystemExit(1)


def init_arg_parser():
    p = argparse.ArgumentParser(description=awacsd.Application.name)
    p.add_argument('-v', '--version',
                   action='version',
                   version=VERSION)
    p.add_argument('-c', '--cfg',
                   default=None,
                   action='store', help='path to service cfg file')
    # --console is used to dump logs during debugging with IDE
    # when stdout isn't terminal but we don't want to log to file
    p.add_argument('--console',
                   default=False,
                   action='store_true',
                   help='redirect log to stdout (overrides config)')
    return p


def main():
    cmdutil.main(init_arg_parser(), awacsd.Application, env_prefix='AWACS',
                 log_fmt=awacsd.Application.LOG_FORMAT,
                 log_filter=awacsd.Application.LOG_FILTER)


if __name__ == '__main__':
    main()
