from infra.awacs.proto import internals_pb2


try:
    from six.moves import copyreg
    import argparse

    from infra.swatlib import cmdutil
    from awacs.app import awacsstatusd
    from awacs.version import VERSION
    from awacs.lib.appconfig import get_config_loader
except KeyboardInterrupt:
    # don't bother user with python stack trace
    # if interrupted (by Ctrl+C) during imports
    raise SystemExit(1)


def init_arg_parser():
    p = argparse.ArgumentParser(description=awacsstatusd.Application.name)
    p.add_argument('-v', '--version',
                   action='version',
                   version=VERSION)
    p.add_argument('-c', '--cfg',
                   required=True,
                   action='store', help='path to service cfg file')
    # --console is used to dump logs during debugging with IDE
    # when stdout isn't terminal but we don't want to log to file
    p.add_argument('--console',
                   default=False,
                   action='store_true',
                   help='redirect log to stdout (overrides config)')
    return p


def main():
    cmdutil.main(init_arg_parser(), awacsstatusd.Application, env_prefix='AWACS',
                 log_fmt=awacsstatusd.Application.LOG_FORMAT,
                 log_filter=awacsstatusd.Application.LOG_FILTER,
                 config_loader=get_config_loader(internals_pb2.AwacsStatusDConfig))


if __name__ == '__main__':
    main()
