import codecs
import jinja2

from sepelib.core import config
from sepelib.core.exceptions import Error
from google.protobuf.json_format import MessageToDict

from awacs.yamlparser import parse


def read_and_render_config(path, config_context=None):
    if isinstance(config_context, list):
        # Assume that jinja context is a list of key-value tuples
        config_context = dict(config_context)
    try:
        with codecs.open(path, encoding='utf-8') as config_file:
            file_content = config_file.read()
    except Exception as e:
        raise Error(u"Error while reading configuration file '{}': {}.", path, e)
    if config_context is not None:
        try:
            file_content = jinja2.Template(file_content).render(**config_context)
        except Exception as e:
            raise Error(u"Error while applying context to configuration file '{}': {}.", path, e)
    return file_content


def get_config_loader(cls):
    def load(path, config_context):
        content = read_and_render_config(path, config_context=config_context)
        config_pb = parse(cls, content)
        config._CONFIG = MessageToDict(config_pb, preserving_proto_field_name=True)

    return load
