import inject

from awacs.lib import mongo


class INannyStaffCache(object):
    @classmethod
    def instance(cls):
        """:rtype: NannyStaffCache"""
        return inject.instance(cls)


class NannyStaffCacheEntryNotFound(Exception):
    pass


class NannyStaffCache(INannyStaffCache):
    def __init__(self, connection_alias, collection_name):
        self.connection_alias = connection_alias
        self.collection_name = collection_name

    @property
    def _col(self):
        db = mongo.get_db(alias=self.connection_alias)
        return db[self.collection_name]

    def get_group_ids(self, login):
        entry = self._col.find_one(login, projection=['group_ids'])
        if entry is None:
            raise NannyStaffCacheEntryNotFound('Nanny cache entry for "{}" is not found'.format(login))
        return entry['group_ids']
