# coding: utf-8
import collections


def compute_slice(skip, limit, default_limit, max_limit):
    """
    :param int skip:
    :param int limit:
    :param int default_limit:
    :param int max_limit:
    :rtype: slice
    """
    start = skip or 0
    if limit is None:
        end = start + default_limit
    else:
        limit = min(max_limit, limit)
        if skip is not None:
            end = skip + limit
        else:
            end = limit
    return slice(start, end)


SliceResult = collections.namedtuple('SliceResult', ['items', 'total'])
