import ipaddress
import six


def is_ip_address(ip):
    """
    :type ip: six.text_type
    :rtype: bool
    """
    try:
        ipaddress.ip_address(ip)
        return True
    except (ipaddress.AddressValueError, ValueError):
        return False


def ipv6(ip):
    try:
        ipaddress.IPv6Address(ip)
        return True
    except ipaddress.AddressValueError:
        return False


def ipv4(ip):
    try:
        ipaddress.IPv4Address(ip)
        return True
    except ipaddress.AddressValueError:
        return False
