# coding: utf-8

import datetime

import inject

from yql.api.v1.client import YqlClient as NativeYqlClient
from yql.client.parameter_value_builder import YqlParameterValueBuilder as ValueBuilder


class IYqlClient(object):
    @classmethod
    def instance(cls):
        """
        :rtype: YqlClient
        """
        return inject.instance(cls)


class YqlClient(IYqlClient):
    @classmethod
    def from_config(cls, cfg):
        return cls(
            token=cfg.get('token'),
        )

    def __init__(self, token=None):
        super(YqlClient, self).__init__()
        self._client = NativeYqlClient(token=token)

    def query(self, sql, **kwargs):
        """
        :param six.text_type sql: query to execute
        :param kwargs: parameters to pass to query prepared with :class:`ValueBuilder`
        :return: iterator over result tables
        """
        req = self._client.query(sql, syntax_version=1)
        req.run(parameters=ValueBuilder.build_json_map(kwargs))
        results = req.get_results()

        for table in results:
            yield table
