# coding: utf-8
import inject

from infra.swatlib.zookeeper_client import ZookeeperClient as BaseZookeeperClient, SequentialGeventHandler
from kazoo.client import KazooState


class IZookeeperClient(object):
    @classmethod
    def instance(cls):
        """
        :rtype: ZookeeperClient
        """
        return inject.instance(cls)


class ZookeeperClient(IZookeeperClient, BaseZookeeperClient):
    def __init__(self, cfg, identifier=None, metrics=None):
        self._metrics = None
        if metrics is not None:
            self._metrics = metrics.path('zookeeper')

        super(ZookeeperClient, self).__init__(
            cfg,
            identifier=identifier,
            handler=SequentialGeventHandler(),
            write_lock_timeout=60 * 6,
            metrics_registry=self._metrics)

        if self._metrics is not None:
            def listener(state):
                if state == KazooState.LOST:
                    self._metrics.get_counter('kazoo-state-lost').inc()
            self.add_listener(listener)
