import collections


ComponentVersion = collections.namedtuple('ComponentVersion', ['type', 'version'])


class ComponentsDiff(object):
    __slots__ = ('added', 'updated', 'removed')

    def __init__(self):
        self.added = set()
        self.updated = set()
        self.removed = set()

    def add(self, component_type, version):
        self.added.add(ComponentVersion(component_type, version))

    def update(self, component_type, new_version):
        self.updated.add(ComponentVersion(component_type, new_version))

    def remove(self, component_type):
        self.removed.add(ComponentVersion(component_type, None))

    def __add__(self, other):
        assert isinstance(other, ComponentsDiff)
        rv = ComponentsDiff()
        rv.added = self.added | other.added
        rv.updated = self.updated | other.updated
        rv.removed = self.removed | other.removed
        return rv
