from awacs.model.balancer.component_transports.diff import ComponentsDiff


def update(instance_spec, instancectl_pb):
    """
    :type instance_spec: dict
    :type instancectl_pb: model_pb2.Component
    :rtype: ComponentsDiff
    """
    rv = ComponentsDiff()
    instancectl = _make_instancectl_fields(instancectl_pb)
    old_instancectl = instance_spec['instancectl']
    task_type = old_instancectl.get('fetchableMeta', {}).get('sandboxResource', {}).get('taskType')
    if task_type is not None:
        instancectl['fetchableMeta']['sandboxResource']['taskType'] = task_type
    if old_instancectl != instancectl:
        rv.update(instancectl_pb.meta.type, instancectl_pb.meta.version)
    instance_spec['instancectl'] = instancectl
    return rv


def _make_instancectl_fields(instancectl_pb):
    sb_pb = instancectl_pb.spec.source.sandbox_resource
    return {
        'fetchableMeta': {
            'type': 'SANDBOX_RESOURCE',
            'sandboxResource': {
                'taskId': sb_pb.task_id,
                'resourceType': sb_pb.resource_type,
                'resourceId': sb_pb.resource_id
            }
        },
        'url': [sb_pb.rbtorrent],
        'version': instancectl_pb.meta.version
    }
