import copy

from infra.awacs.proto import model_pb2
from awacs.model import components


def find_layer(layers, component_type):
    """
    :type component_type: model_pb2.ComponentMeta.Type
    """
    for layer in layers:
        resource_type = layer['fetchableMeta']['sandboxResource']['resourceType']
        resource_component_type = components.LAYER_COMPONENT_TYPES_BY_RESOURCE_TYPE.get(resource_type)
        if component_type == resource_component_type:
            return layer
        elif resource_component_type is None:
            raise RuntimeError('No layer components matched for resource type: "{}"'.format(resource_type))


def make_layer(component_pb):
    sb_pb = component_pb.spec.source.sandbox_resource
    return {
        'fetchableMeta': {
            'type': 'SANDBOX_RESOURCE',
            'sandboxResource': {
                'taskId': sb_pb.task_id,
                'resourceType': sb_pb.resource_type,
                'resourceId': sb_pb.resource_id,
                'taskType': sb_pb.task_type,
            }
        },
        'url': [sb_pb.rbtorrent],
    }
