from .util import add_component_to_files, remove_component_from_files


def add_or_update(resources, component_pb, local_path, extract_path=''):
    """
    :type resources: dict
    :type component_pb: model_pb2.Component
    :type local_path: six.text_type
    :type extract_path: six.text_type
    :rtype: awacs.model.balancer.component_transports.diff.ComponentsDiff
    """
    sandbox_files = resources.get('sandbox_files', [])
    component_sandbox_file = {
        'task_type': component_pb.spec.source.sandbox_resource.task_type,
        'task_id': component_pb.spec.source.sandbox_resource.task_id,
        'resource_type': component_pb.spec.source.sandbox_resource.resource_type,
        'resource_id': component_pb.spec.source.sandbox_resource.resource_id,
        'local_path': local_path,
        'is_dynamic': False,
        'extract_path': extract_path,
    }
    diff = add_component_to_files(sandbox_files, component_sandbox_file, component_pb, local_path, extract_path)
    resources['sandbox_files'] = sandbox_files
    return diff


def remove(resources, component_type, local_path):
    """
    :type resources: dict
    :type component_type: model_pb2.ComponentMeta.Type
    :type local_path: six.text_type
    :rtype: awacs.model.balancer.component_transports.diff.ComponentsDiff
    """
    sandbox_files = resources.get('sandbox_files', [])
    filtered_sandbox_files, diff = remove_component_from_files(sandbox_files, component_type, local_path)
    resources['sandbox_files'] = filtered_sandbox_files
    return diff
