from .util import add_component_to_files, remove_component_from_files


def add_or_update(resources, component_pb, local_path, extract_path=''):
    """
    :type resources: dict
    :type component_pb: model_pb2.Component
    :type local_path: six.text_type
    :type extract_path: six.text_type
    :rtype: awacs.model.balancer.component_transports.diff.ComponentsDiff
    """
    url_files = resources.get('url_files', [])
    component_url_file = {
        'local_path': local_path,
        'is_dynamic': False,
        'extract_path': extract_path,
        'url': component_pb.spec.source.url_file.url,
    }
    diff = add_component_to_files(url_files, component_url_file, component_pb, local_path, extract_path)
    resources['url_files'] = url_files
    return diff


def remove(resources, component_type, local_path):
    """
    :type resources: dict
    :type component_type: model_pb2.ComponentMeta.Type
    :type local_path: six.text_type
    :rtype: awacs.model.balancer.component_transports.diff.ComponentsDiff
    """
    url_files = resources.get('url_files', [])
    filtered_url_files, diff = remove_component_from_files(url_files, component_type, local_path)
    resources['url_files'] = filtered_url_files
    return diff
