from awacs.model.balancer.component_transports.diff import ComponentsDiff


def find_file_by_local_path(files, local_path):
    for file in files:
        if file.get('local_path') == local_path:
            return file
    return None


def add_component_to_files(files, component_file, component_pb, local_path, extract_path):
    """
    :type files: list[dict]
    :type component_file: dict
    :type component_pb: model_pb2.Component
    :type local_path: six.text_type
    :type extract_path: six.text_type
    :rtype: ComponentsDiff
    """
    diff = ComponentsDiff()
    existing_file = find_file_by_local_path(files, local_path)
    if existing_file is not None:
        if extract_path == '' and 'extract_path' not in existing_file:
            component_file.pop('extract_path')
        if component_file != existing_file:
            diff.update(component_pb.meta.type, component_pb.meta.version)
            existing_file.clear()
            existing_file.update(component_file)
    else:
        files.append(component_file)
        diff.add(component_pb.meta.type, component_pb.meta.version)
    return diff


def remove_component_from_files(files, component_type, local_path):
    """
    :type files: list[dict]
    :type component_type: model_pb2.ComponentMeta.Type
    :type local_path: six.text_type
    :rtype: list[dict], ComponentsDiff
    """
    diff = ComponentsDiff()
    filtered_files = []
    for file in files:
        if file.get('local_path') != local_path:
            filtered_files.append(file)
        else:
            diff.remove(component_type)
    return filtered_files, diff
