import nanny_rpc_client
try:
    from yp_lite_ui_repo import endpoint_sets_api_pb2
except ImportError:
    # for Arcadia:
    from infra.nanny.yp_lite_api.proto import endpoint_sets_api_pb2


from awacs.lib.ypliterpcclient import IYpLiteRpcClient


def endpoint_set_exists(endpoint_set_id, cluster, yp_lite_rpc_client=None):
    yp_lite_rpc_client = yp_lite_rpc_client or IYpLiteRpcClient.instance()

    req_pb = endpoint_sets_api_pb2.GetEndpointSetRequest(
        id=endpoint_set_id,
        cluster=cluster,
    )

    try:
        yp_lite_rpc_client.get_endpoint_set(req_pb)
        return True
    except nanny_rpc_client.exceptions.NotFoundError:
        return False
