# coding: utf-8
import six
from awacs.lib.yamlparser import errors as yamlparsererrors


class Error(Exception):
    pass


class ConfigValidationError(Error):
    def __init__(self, message, cause=None, error=None):
        self.message = message
        self.cause = cause
        self.error = error
        super(ConfigValidationError, self).__init__(self, message)

    def to_dict(self):
        rv = {'message': self.message}
        if isinstance(self.error, yamlparsererrors.Error):
            rv['error'] = self.error.to_dict()
        return rv

    def __repr__(self):
        rv = six.text_type(self)
        if self.cause is not None:
            rv = '{} in {}'.format(rv, self.cause)
        return rv

    def __str__(self):
        if self.error:
            return '{}: {}'.format(self.message, self.error)
        else:
            return six.text_type(self.message)

    __unicode = __str__
