import time

from infra.awacs.proto import model_pb2


def needs_revocation(cert_pb):
    """
    :type cert_pb: model_pb2.Certificate | model_pb2.CertificateRenewal
    :rtype: bool
    """
    return cert_pb.spec.state == model_pb2.CertificateSpec.REVOKED_AND_REMOVED_FROM_AWACS_AND_STORAGE


def needs_storage_removal(cert_pb):
    """
    :type cert_pb: model_pb2.Certificate | model_pb2.CertificateRenewal
    :rtype: bool
    """
    return cert_pb.spec.state in (model_pb2.CertificateSpec.REVOKED_AND_REMOVED_FROM_AWACS_AND_STORAGE,
                                  model_pb2.CertificateSpec.REMOVED_FROM_AWACS_AND_STORAGE)


def is_expired(cert_pb):
    """
    :type cert_pb: model_pb2.Certificate | model_pb2.CertificateRenewal | awacs.proto.model_pb2.CertificateRevision
    :rtype: bool
    """
    not_after = cert_pb.spec.fields.validity.not_after
    not_after = not_after.ToSeconds() if not_after else 0
    if not not_after:
        raise ValueError('Certificate "{}": empty validity.not_after')
    return not_after <= time.time()
