from awacs.lib import zk_storage
from infra.awacs.proto import model_pb2, internals_pb2


class GenerationCodec(zk_storage.Codec):
    @staticmethod
    def set_generation(obj, generation):
        obj.meta.generation = generation

    @staticmethod
    def get_generation(obj):
        return int(obj.meta.generation)


class StateGenerationCodec(zk_storage.Codec):
    @staticmethod
    def set_generation(obj, generation):
        obj.generation = generation

    @staticmethod
    def get_generation(obj):
        return int(obj.generation)


class BalancerStateCodec(StateGenerationCodec):
    message_cls = model_pb2.BalancerState


class L3BalancerStateCodec(StateGenerationCodec):
    message_cls = model_pb2.L3BalancerState


class DnsRecordStateCodec(StateGenerationCodec):
    message_cls = model_pb2.DnsRecordState


class NamespaceCodec(GenerationCodec):
    message_cls = model_pb2.Namespace


class ComponentCodec(GenerationCodec):
    message_cls = model_pb2.Component


class KnobCodec(GenerationCodec):
    message_cls = model_pb2.Knob


class CertificateCodec(GenerationCodec):
    message_cls = model_pb2.Certificate


class CertificateRenewalCodec(GenerationCodec):
    message_cls = model_pb2.CertificateRenewal


class BalancerCodec(GenerationCodec):
    message_cls = model_pb2.Balancer


class L3BalancerCodec(GenerationCodec):
    message_cls = model_pb2.L3Balancer


class UpstreamCodec(GenerationCodec):
    message_cls = model_pb2.Upstream


class DomainCodec(GenerationCodec):
    message_cls = model_pb2.Domain


class DomainOperationCodec(GenerationCodec):
    message_cls = model_pb2.DomainOperation


class BalancerOperationCodec(GenerationCodec):
    message_cls = model_pb2.BalancerOperation


class BackendCodec(GenerationCodec):
    message_cls = model_pb2.Backend


class EndpointSetCodec(GenerationCodec):
    message_cls = model_pb2.EndpointSet


class BalancerAspectsSetCodec(GenerationCodec):
    message_cls = model_pb2.BalancerAspectsSet


class NamespaceAspectsSetCodec(GenerationCodec):
    message_cls = model_pb2.NamespaceAspectsSet


class DnsRecordCodec(GenerationCodec):
    message_cls = model_pb2.DnsRecord


class DnsRecordOperationCodec(GenerationCodec):
    message_cls = model_pb2.DnsRecordOperation


class NameServerCodec(GenerationCodec):
    message_cls = model_pb2.NameServer


class StaffCacheEntryCodec(zk_storage.Codec):
    message_cls = internals_pb2.CacheEntry

    @staticmethod
    def set_generation(obj, generation):
        pass

    @staticmethod
    def get_generation(obj):
        return None
