# coding: utf-8
import textwrap

import inject

from awacs.lib import yql_client
from sepelib.core import config


STATISTICS_QUERY_TEMPLATE = textwrap.dedent(
    """\
    USE hahn;
    PRAGMA AnsiInForEmptyOrNullableItemsCollections;

    SELECT
        countIf(method = "sms") as sms,
        countIf(method = "email") as email,
        countIf(method = "telegram") as telegram,
        countIf(method = "yachats") as yachats,
        countIf(method = "phone_escalation") as phone_escalation,
        countIf(method NOT IN ("sms", "email", "telegram", "yachats", "phone_escalation")) as other
    FROM `//home/logfeller/logs/juggler-banshee-log/1d/{yesterday}`
    WHERE event_type = "message_processed" and checks LIKE "{alerting_prefix}.%";
    """
).strip()


class NotificationsStatisticsUpdater(object):
    _yql_client = inject.attr(yql_client.IYqlClient)  # type: yql_client.YqlClient

    def update_date_notifications_statistics(self, dt, date_statistics_pb):
        """
        :type dt: datetime.datetime
        :type data_statistics_pb: model_pb2.NotificationsStatisticsEntry.DateStatistics
        """
        date = dt.strftime('%Y-%m-%d')
        alerting_prefix = config.get_value('alerting.name_prefix', 'undefined')
        query = STATISTICS_QUERY_TEMPLATE.format(yesterday=date, alerting_prefix=alerting_prefix)
        table = next(iter(self._yql_client.query(query)))
        row = next(iter(table.rows))
        for name, cell in zip(table.column_names, row):
            date_statistics_pb.alerts_sent[name] = cell
