# coding: utf-8
import collections

import six
import inject

from awacs.model import cache
from infra.awacs.proto import model_pb2


def get_str_type(enum_class, value):
    try:
        return enum_class.Name(value)
    except ValueError:
        return None


class UsageStatisticsUpdater(object):
    _cache = inject.attr(cache.IAwacsCache)  # type: cache.AwacsCache

    MAX_UPSTREAMS_NUMBER = 1000

    @staticmethod
    def fill_pie(pie_pb, id_, counter):
        """
        :type pie_pb: UsageStatisticsEntry.CommonCounters.Pie
        :type id_: six.text_type
        :type counter: collections.Counter
        """
        pie_pb.id = id_
        for key, count in six.iteritems(counter):
            pie_pb.slices[six.text_type(key)] = count

    def update_date_statistics(self, date_statistics_pb):
        """
        :type date_statistics_pb: model_pb2.UsageStatisticsEntry.DateStatistics
        """
        date_statistics_pb.namespaces_count = self._cache.count_namespaces()

        total_pb = date_statistics_pb.total
        total_pb.balancers_count = self._cache.count_balancers()
        total_pb.l3_balancers_count = self._cache.count_l3_balancers()
        total_pb.dns_records_count = self._cache.count_dns_records()
        total_pb.upstreams_count = self._cache.count_upstreams()
        total_pb.endpoint_sets_count = self._cache.count_endpoint_sets()
        total_pb.certs_count = self._cache.count_certs()
        total_pb.domains_count = self._cache.count_domains()
        total_pb.knobs_count = self._cache.count_knobs()

        total_is_alerting_enabled = collections.Counter()
        total_alerting_version = collections.Counter()

        total_l7_macro_version = collections.Counter()
        total_l7_upstream_macro_version = collections.Counter()

        total_balancers_by_platform = collections.Counter()
        total_balancers_by_instances_count = collections.Counter()

        total_balancers_by_sd_backends_count = collections.Counter()
        total_balancers_by_yp_endpoint_sets_backends_count = collections.Counter()
        total_balancers_by_nanny_snapshots_backends_count = collections.Counter()
        total_balancers_by_gencfg_groups_backends_count = collections.Counter()
        total_balancers_by_manual_backends_count = collections.Counter()

        total_balancers_by_is_unistat_enabled = collections.Counter()
        total_balancers_by_is_easy_mode_enabled = collections.Counter()
        total_balancers_by_includes_domains = collections.Counter()
        total_balancers_by_config_lines_count = collections.Counter()
        total_balancers_compat_options_count = collections.Counter()
        total_balancers_by_balancer2_modules_total_count = collections.Counter()
        total_balancers_by_balancer2_modules_total_gpb_count = collections.Counter()
        total_balancers_by_balancer2_modules_without_arl_count = collections.Counter()
        total_balancers_by_balancer2_modules_without_arl_gpb_count = collections.Counter()
        total_balancers_by_balancer2_modules_without_arl_and_watermark_gpb_count = collections.Counter()

        total_upstreams_by_is_easy_mode_enabled = collections.Counter()
        total_upstreams_by_config_lines_count = collections.Counter()
        total_upstreams_by_balancer2_modules_total_count = collections.Counter()
        total_upstreams_by_balancer2_modules_total_gpb_count = collections.Counter()
        total_upstreams_by_balancer2_modules_without_arl_count = collections.Counter()
        total_upstreams_by_balancer2_modules_without_arl_gpb_count = collections.Counter()
        total_upstreams_by_balancer2_modules_without_arl_and_watermark_gpb_count = collections.Counter()

        total_backends_by_type = collections.Counter()

        total_certs_by_source = collections.Counter()

        total_domains_by_protocol = collections.Counter()
        total_domains_by_usage = collections.Counter()

        for namespace_pb in self._cache.list_all_namespaces():
            namespace_id = namespace_pb.meta.id

            if namespace_pb.HasField('spec') and namespace_pb.spec.HasField('alerting'):
                total_is_alerting_enabled['True'] += 1
                total_alerting_version[namespace_pb.spec.alerting.version] += 1
            else:
                total_is_alerting_enabled['False'] += 1

            ns_pb = date_statistics_pb.by_namespace[namespace_id]

            ns_l7_macro_version = collections.Counter()
            ns_l7_upstream_macro_version = collections.Counter()

            ns_balancers_by_platform = collections.Counter()
            ns_balancers_by_instances_count = collections.Counter()

            ns_balancers_by_sd_backends_count = collections.Counter()
            ns_balancers_by_yp_endpoint_sets_backends_count = collections.Counter()
            ns_balancers_by_nanny_snapshots_backends_count = collections.Counter()
            ns_balancers_by_gencfg_groups_backends_count = collections.Counter()
            ns_balancers_by_manual_backends_count = collections.Counter()

            ns_balancers_by_is_unistat_enabled = collections.Counter()
            ns_balancers_by_is_thread_mode_enabled = collections.Counter()
            ns_balancers_by_is_easy_mode_enabled = collections.Counter()
            ns_balancers_by_includes_domains = collections.Counter()
            ns_balancers_by_config_lines_count = collections.Counter()
            ns_balancers_compat_options_count = collections.Counter()
            ns_balancers_by_balancer2_modules_total_count = collections.Counter()
            ns_balancers_by_balancer2_modules_total_gpb_count = collections.Counter()
            ns_balancers_by_balancer2_modules_with_dynamic_count = collections.Counter()
            ns_balancers_by_balancer2_modules_without_arl_count = collections.Counter()
            ns_balancers_by_balancer2_modules_without_arl_gpb_count = collections.Counter()
            ns_balancers_by_balancer2_modules_without_arl_and_watermark_gpb_count = collections.Counter()

            ns_upstreams_by_is_easy_mode_enabled = collections.Counter()
            ns_upstreams_by_config_lines_count = collections.Counter()
            ns_upstreams_compat_options_count = collections.Counter()
            ns_upstreams_by_balancer2_modules_total_count = collections.Counter()
            ns_upstreams_by_balancer2_modules_total_gpb_count = collections.Counter()
            ns_upstreams_by_balancer2_modules_with_dynamic_count = collections.Counter()
            ns_upstreams_by_balancer2_modules_without_arl_count = collections.Counter()
            ns_upstreams_by_balancer2_modules_without_arl_gpb_count = collections.Counter()
            ns_upstreams_by_balancer2_modules_without_arl_and_watermark_gpb_count = collections.Counter()

            ns_backends_by_type = collections.Counter()

            ns_certs_by_source = collections.Counter()

            ns_domains_by_protocol = collections.Counter()
            ns_domains_by_usage = collections.Counter()

            ns_pb.balancers_count = self._cache.count_balancers(namespace_id=namespace_id)
            ns_pb.l3_balancers_count = self._cache.count_l3_balancers(namespace_id=namespace_id)
            ns_pb.dns_records_count = self._cache.count_dns_records(namespace_id=namespace_id)
            ns_pb.upstreams_count = self._cache.count_upstreams(namespace_id=namespace_id)
            ns_pb.endpoint_sets_count = self._cache.count_endpoint_sets(namespace_id=namespace_id)
            ns_pb.certs_count = self._cache.count_certs(namespace_id=namespace_id)
            ns_pb.domains_count = self._cache.count_domains(namespace_id=namespace_id)
            ns_pb.knobs_count = self._cache.count_knobs(namespace_id=namespace_id)

            aspects_set_pb = self._cache.get_namespace_aspects_set(namespace_id)
            s_pb = aspects_set_pb.content.statistics.content

            for d_pb in s_pb.domains:  # type: model_pb2.NamespaceStatisticsAspectsContent.DomainStatisticsAspects
                type_str = get_str_type(model_pb2.DomainSpec.Config.Protocol, d_pb.protocol)
                if type_str is not None:
                    ns_domains_by_protocol[type_str] += 1
                    ns_domains_by_usage[d_pb.is_included] += 1

            for c_pb in s_pb.certs:  # type: model_pb2.NamespaceStatisticsAspectsContent.CertStatisticsAspects
                type_str = get_str_type(model_pb2.CertificateSpec.Source, c_pb.source)
                if type_str is not None:
                    ns_certs_by_source[type_str] += 1

            for b_pb in s_pb.backends:  # type: model_pb2.NamespaceStatisticsAspectsContent.BackendStatisticsAspects
                type_str = get_str_type(model_pb2.BackendSelector.Type, b_pb.type)
                if type_str is not None:
                    ns_backends_by_type[type_str] += 1

            for u_pb in s_pb.upstreams:  # type: model_pb2.NamespaceStatisticsAspectsContent.UpstreamStatisticsAspects
                ns_upstreams_by_is_easy_mode_enabled[u_pb.is_easy_mode_enabled] += 1
                ns_upstreams_by_config_lines_count[u_pb.config_lines_count] += 1
                ns_upstreams_compat_options_count.update(u_pb.compat_options)
                if u_pb.is_easy_mode_enabled:
                    total_l7_upstream_macro_version[u_pb.l7_upstream_macro_version] += 1
                    ns_l7_upstream_macro_version[u_pb.l7_upstream_macro_version] += 1
                ns_upstreams_by_balancer2_modules_total_count[
                    u_pb.balancer2_modules_total] += 1
                ns_upstreams_by_balancer2_modules_total_gpb_count[
                    u_pb.balancer2_modules_total_gpb] += 1
                ns_upstreams_by_balancer2_modules_with_dynamic_count[
                    u_pb.balancer2_modules_with_dynamic_count] += 1
                ns_upstreams_by_balancer2_modules_without_arl_count[
                    u_pb.balancer2_modules_without_arl_count] += 1
                ns_upstreams_by_balancer2_modules_without_arl_gpb_count[
                    u_pb.balancer2_modules_without_arl_gpb_count] += 1
                ns_upstreams_by_balancer2_modules_without_arl_and_watermark_gpb_count[
                    u_pb.balancer2_modules_without_arl_and_watermark_gpb_count] += 1

            for b_pb in s_pb.balancers:  # type: model_pb2.NamespaceStatisticsAspectsContent.BalancerStatisticsAspects
                platform_str = get_str_type(
                    model_pb2.NamespaceStatisticsAspectsContent.BalancerStatisticsAspects.Platform,
                    b_pb.platform)
                if platform_str is not None:
                    ns_balancers_by_platform[platform_str] += 1
                if b_pb.is_easy_mode_enabled:
                    total_l7_macro_version[b_pb.l7_macro_version] += 1
                    ns_l7_macro_version[b_pb.l7_macro_version] += 1
                ns_balancers_by_instances_count[b_pb.instances_count] += 1

                ns_balancers_by_sd_backends_count[b_pb.sd_backends_count] += 1
                ns_balancers_by_yp_endpoint_sets_backends_count[b_pb.yp_endpoint_sets_backends_count] += 1
                ns_balancers_by_nanny_snapshots_backends_count[b_pb.nanny_snapshots_backends_count] += 1
                ns_balancers_by_gencfg_groups_backends_count[b_pb.gencfg_groups_backends_count] += 1
                ns_balancers_by_manual_backends_count[b_pb.manual_backends_count] += 1

                ns_balancers_by_is_thread_mode_enabled[b_pb.is_thread_mode_enabled] += 1
                ns_balancers_by_is_unistat_enabled[b_pb.is_unistat_enabled] += 1
                ns_balancers_by_is_easy_mode_enabled[b_pb.is_easy_mode_enabled] += 1
                ns_balancers_by_includes_domains[b_pb.includes_domains] += 1
                ns_balancers_compat_options_count.update(b_pb.compat_options)
                ns_balancers_by_balancer2_modules_total_count[
                    b_pb.balancer2_modules_total] += 1
                ns_balancers_by_balancer2_modules_total_gpb_count[
                    b_pb.balancer2_modules_total_gpb] += 1
                ns_balancers_by_balancer2_modules_with_dynamic_count[
                    b_pb.balancer2_modules_with_dynamic_count] += 1
                ns_balancers_by_balancer2_modules_without_arl_count[
                    b_pb.balancer2_modules_without_arl_count] += 1
                ns_balancers_by_balancer2_modules_without_arl_gpb_count[
                    b_pb.balancer2_modules_without_arl_gpb_count] += 1
                ns_balancers_by_balancer2_modules_without_arl_and_watermark_gpb_count[
                    b_pb.balancer2_modules_without_arl_and_watermark_gpb_count] += 1

            self.fill_pie(ns_pb.balancer_pies.add(), u'platform', ns_balancers_by_platform)
            self.fill_pie(ns_pb.balancer_pies.add(), u'instances_count', ns_balancers_by_instances_count)

            self.fill_pie(ns_pb.balancer_pies.add(), u'sd_backends_count',
                          ns_balancers_by_sd_backends_count)
            self.fill_pie(ns_pb.balancer_pies.add(), u'yp_endpoint_sets_backends_count',
                          ns_balancers_by_yp_endpoint_sets_backends_count)
            self.fill_pie(ns_pb.balancer_pies.add(), u'nanny_snapshots_backends_count',
                          ns_balancers_by_nanny_snapshots_backends_count)
            self.fill_pie(ns_pb.balancer_pies.add(), u'gencfg_groups_backends_count',
                          ns_balancers_by_gencfg_groups_backends_count)
            self.fill_pie(ns_pb.balancer_pies.add(), u'manual_backends_count',
                          ns_balancers_by_manual_backends_count)

            self.fill_pie(ns_pb.balancer_pies.add(), u'l7_macro_versions', ns_l7_macro_version)
            self.fill_pie(ns_pb.balancer_pies.add(), u'is_unistat_enabled', ns_balancers_by_is_unistat_enabled)
            self.fill_pie(ns_pb.balancer_pies.add(), u'is_easy_mode_enabled', ns_balancers_by_is_easy_mode_enabled)
            self.fill_pie(ns_pb.balancer_pies.add(), u'is_thread_mode_enabled', ns_balancers_by_is_thread_mode_enabled)
            self.fill_pie(ns_pb.balancer_pies.add(), u'includes_domains', ns_balancers_by_includes_domains)
            self.fill_pie(ns_pb.balancer_pies.add(), u'config_lines_count', ns_balancers_by_config_lines_count)
            self.fill_pie(ns_pb.balancer_pies.add(), u'compat_options_count', ns_balancers_compat_options_count)
            self.fill_pie(ns_pb.balancer_pies.add(), u'balancer2_modules_total_count',
                          ns_balancers_by_balancer2_modules_total_count)
            self.fill_pie(ns_pb.balancer_pies.add(), u'balancer2_modules_total_gpb_count',
                          ns_balancers_by_balancer2_modules_total_gpb_count)
            self.fill_pie(ns_pb.balancer_pies.add(), u'balancer2_modules_with_dynamic_count',
                          ns_balancers_by_balancer2_modules_with_dynamic_count)
            self.fill_pie(ns_pb.balancer_pies.add(), u'balancer2_modules_without_arl_count',
                          ns_balancers_by_balancer2_modules_without_arl_count)
            self.fill_pie(ns_pb.balancer_pies.add(), u'balancer2_modules_without_arl_gpb_count',
                          ns_balancers_by_balancer2_modules_without_arl_gpb_count)
            self.fill_pie(ns_pb.balancer_pies.add(), u'balancer2_modules_without_arl_and_watermark_gpb_count',
                          ns_balancers_by_balancer2_modules_without_arl_and_watermark_gpb_count)

            self.fill_pie(ns_pb.upstream_pies.add(), u'l7_upstream_macro_versions', ns_l7_upstream_macro_version)
            self.fill_pie(ns_pb.upstream_pies.add(), u'is_easy_mode_enabled', ns_upstreams_by_is_easy_mode_enabled)
            self.fill_pie(ns_pb.upstream_pies.add(), u'config_lines_count', ns_upstreams_by_config_lines_count)
            self.fill_pie(ns_pb.upstream_pies.add(), u'compat_options_count', ns_upstreams_compat_options_count)
            self.fill_pie(ns_pb.upstream_pies.add(), u'balancer2_modules_total_count',
                          ns_upstreams_by_balancer2_modules_total_count)
            self.fill_pie(ns_pb.upstream_pies.add(), u'balancer2_modules_total_gpb_count',
                          ns_upstreams_by_balancer2_modules_total_gpb_count)
            self.fill_pie(ns_pb.upstream_pies.add(), u'balancer2_modules_with_dynamic_count',
                          ns_upstreams_by_balancer2_modules_with_dynamic_count)
            self.fill_pie(ns_pb.upstream_pies.add(), u'balancer2_modules_without_arl_count',
                          ns_upstreams_by_balancer2_modules_without_arl_count)
            self.fill_pie(ns_pb.upstream_pies.add(), u'balancer2_modules_without_arl_gpb_count',
                          ns_upstreams_by_balancer2_modules_without_arl_gpb_count)
            self.fill_pie(ns_pb.upstream_pies.add(), u'balancer2_modules_without_arl_and_watermark_gpb_count',
                          ns_upstreams_by_balancer2_modules_without_arl_and_watermark_gpb_count)

            self.fill_pie(ns_pb.backend_pies.add(), u'type', ns_backends_by_type)

            self.fill_pie(ns_pb.cert_pies.add(), u'source', ns_certs_by_source)

            self.fill_pie(ns_pb.domain_pies.add(), u'protocol', ns_domains_by_protocol)
            self.fill_pie(ns_pb.domain_pies.add(), u'usage', ns_domains_by_usage)

            total_balancers_by_platform.update(ns_balancers_by_platform)
            total_balancers_by_instances_count.update(ns_balancers_by_instances_count)

            total_balancers_by_sd_backends_count.update(ns_balancers_by_sd_backends_count)
            total_balancers_by_yp_endpoint_sets_backends_count.update(ns_balancers_by_yp_endpoint_sets_backends_count)
            total_balancers_by_nanny_snapshots_backends_count.update(ns_balancers_by_nanny_snapshots_backends_count)
            total_balancers_by_gencfg_groups_backends_count.update(ns_balancers_by_gencfg_groups_backends_count)
            total_balancers_by_manual_backends_count.update(ns_balancers_by_manual_backends_count)

            total_balancers_by_is_unistat_enabled.update(ns_balancers_by_is_unistat_enabled)
            total_balancers_by_is_easy_mode_enabled.update(ns_balancers_by_is_easy_mode_enabled)
            total_balancers_by_includes_domains.update(ns_balancers_by_includes_domains)
            total_balancers_by_config_lines_count.update(ns_balancers_by_config_lines_count)
            total_balancers_compat_options_count.update(ns_balancers_compat_options_count)
            total_balancers_by_balancer2_modules_total_count.update(
                ns_balancers_by_balancer2_modules_total_count)
            total_balancers_by_balancer2_modules_total_gpb_count.update(
                ns_balancers_by_balancer2_modules_total_gpb_count)
            total_balancers_by_balancer2_modules_without_arl_count.update(
                ns_balancers_by_balancer2_modules_without_arl_count)
            total_balancers_by_balancer2_modules_without_arl_gpb_count.update(
                ns_balancers_by_balancer2_modules_without_arl_gpb_count)
            total_balancers_by_balancer2_modules_without_arl_and_watermark_gpb_count.update(
                ns_balancers_by_balancer2_modules_without_arl_and_watermark_gpb_count)

            total_upstreams_by_is_easy_mode_enabled.update(ns_upstreams_by_is_easy_mode_enabled)
            total_upstreams_by_config_lines_count.update(ns_upstreams_by_config_lines_count)
            total_upstreams_by_balancer2_modules_total_count.update(
                ns_upstreams_by_balancer2_modules_total_count)
            total_upstreams_by_balancer2_modules_total_gpb_count.update(
                ns_upstreams_by_balancer2_modules_total_gpb_count)
            total_upstreams_by_balancer2_modules_without_arl_count.update(
                ns_upstreams_by_balancer2_modules_without_arl_count)
            total_upstreams_by_balancer2_modules_without_arl_gpb_count.update(
                ns_upstreams_by_balancer2_modules_without_arl_gpb_count)
            total_upstreams_by_balancer2_modules_without_arl_and_watermark_gpb_count.update(
                ns_upstreams_by_balancer2_modules_without_arl_and_watermark_gpb_count)

            total_backends_by_type.update(ns_backends_by_type)

            total_certs_by_source.update(ns_certs_by_source)

            total_domains_by_protocol.update(ns_domains_by_protocol)
            total_domains_by_usage.update(ns_domains_by_usage)

        self.fill_pie(total_pb.balancer_pies.add(), u'platform', total_balancers_by_platform)
        self.fill_pie(total_pb.balancer_pies.add(), u'instances_count', total_balancers_by_instances_count)

        self.fill_pie(total_pb.balancer_pies.add(), u'sd_backends_count',
                      total_balancers_by_sd_backends_count)
        self.fill_pie(total_pb.balancer_pies.add(), u'yp_endpoint_sets_backends_count',
                      total_balancers_by_yp_endpoint_sets_backends_count)
        self.fill_pie(total_pb.balancer_pies.add(), u'nanny_snapshots_backends_count',
                      total_balancers_by_nanny_snapshots_backends_count)
        self.fill_pie(total_pb.balancer_pies.add(), u'gencfg_groups_backends_count',
                      total_balancers_by_gencfg_groups_backends_count)
        self.fill_pie(total_pb.balancer_pies.add(), u'manual_backends_count',
                      total_balancers_by_manual_backends_count)

        self.fill_pie(total_pb.balancer_pies.add(), u'l7_macro_versions', total_l7_macro_version)
        self.fill_pie(total_pb.balancer_pies.add(), u'is_unistat_enabled', total_balancers_by_is_unistat_enabled)
        self.fill_pie(total_pb.balancer_pies.add(), u'is_easy_mode_enabled', total_balancers_by_is_easy_mode_enabled)
        self.fill_pie(total_pb.balancer_pies.add(), u'includes_domains', total_balancers_by_includes_domains)
        self.fill_pie(total_pb.balancer_pies.add(), u'config_lines_count', total_balancers_by_config_lines_count)
        self.fill_pie(total_pb.balancer_pies.add(), u'compat_options_count', total_balancers_compat_options_count)
        self.fill_pie(total_pb.balancer_pies.add(), u'balancer2_modules_total_count',
                      total_balancers_by_balancer2_modules_total_count)
        self.fill_pie(total_pb.balancer_pies.add(), u'balancer2_modules_total_gpb_count',
                      total_balancers_by_balancer2_modules_total_gpb_count)
        self.fill_pie(total_pb.balancer_pies.add(), u'balancer2_modules_total_gpb_count',
                      total_balancers_by_balancer2_modules_total_gpb_count)
        self.fill_pie(total_pb.balancer_pies.add(), u'balancer2_modules_without_arl_count',
                      total_balancers_by_balancer2_modules_without_arl_count)
        self.fill_pie(total_pb.balancer_pies.add(), u'balancer2_modules_without_arl_gpb_count',
                      total_balancers_by_balancer2_modules_without_arl_gpb_count)
        self.fill_pie(total_pb.balancer_pies.add(), u'balancer2_modules_without_arl_and_watermark_gpb_count',
                      total_balancers_by_balancer2_modules_without_arl_and_watermark_gpb_count)

        self.fill_pie(total_pb.upstream_pies.add(), u'l7_upstream_macro_versions', total_l7_upstream_macro_version)
        self.fill_pie(total_pb.upstream_pies.add(), u'is_easy_mode_enabled', total_upstreams_by_is_easy_mode_enabled)
        self.fill_pie(total_pb.upstream_pies.add(), u'config_lines_count', total_upstreams_by_config_lines_count)
        self.fill_pie(total_pb.upstream_pies.add(), u'balancer2_modules_total_count',
                      total_upstreams_by_balancer2_modules_total_count)
        self.fill_pie(total_pb.upstream_pies.add(), u'balancer2_modules_total_gpb_count',
                      total_upstreams_by_balancer2_modules_total_gpb_count)
        self.fill_pie(total_pb.upstream_pies.add(), u'balancer2_modules_total_gpb_count',
                      total_upstreams_by_balancer2_modules_total_gpb_count)
        self.fill_pie(total_pb.upstream_pies.add(), u'balancer2_modules_without_arl_count',
                      total_upstreams_by_balancer2_modules_without_arl_count)
        self.fill_pie(total_pb.upstream_pies.add(), u'balancer2_modules_without_arl_gpb_count',
                      total_upstreams_by_balancer2_modules_without_arl_gpb_count)
        self.fill_pie(total_pb.upstream_pies.add(), u'balancer2_modules_without_arl_and_watermark_gpb_count',
                      total_upstreams_by_balancer2_modules_without_arl_and_watermark_gpb_count)

        self.fill_pie(total_pb.backend_pies.add(), u'type', total_backends_by_type)

        self.fill_pie(total_pb.cert_pies.add(), u'source', total_certs_by_source)

        self.fill_pie(total_pb.domain_pies.add(), u'protocol', total_domains_by_protocol)
        self.fill_pie(total_pb.domain_pies.add(), u'usage', total_domains_by_usage)

        self.fill_pie(date_statistics_pb.namespace_pies.add(), u'is_alerting_enabled', total_is_alerting_enabled)
        self.fill_pie(date_statistics_pb.namespace_pies.add(), u'alerting_version', total_alerting_version)
