import attr
import six


@attr.s(slots=True, weakref_slot=True, frozen=True)
class ExternalCluster(object):
    name = attr.ib(type=six.text_type)
    yp_cluster = attr.ib(type=six.text_type)
    node_segment = attr.ib(type=six.text_type)


AZURE_CLUSTERS = [
    ExternalCluster(
        name='US_EAST1',
        yp_cluster='VLA',
        node_segment='azuseast1',
    ),
    ExternalCluster(
        name='WEST_EU',
        yp_cluster='VLA',
        node_segment='azwesteu',
    ),
]

AZURE_CLUSTERS_BY_NAME = {ec.name: ec for ec in AZURE_CLUSTERS}  # type: dict[six.text_type, ExternalCluster]

