import inject

from awacs.model import cache
from awacs.model.l3_balancer import l3_balancer


class DiscovererV2(object):
    _cache = inject.attr(cache.IAwacsCache)  # type: cache.AwacsCache
    __slots__ = (u'_namespace_id', u'_l3_balancer_id')

    def __init__(self, namespace_id, l3_balancer_id):
        self._namespace_id = namespace_id
        self._l3_balancer_id = l3_balancer_id

    def discover(self, ctx, state_handler, vectors):
        """
        1) gather all revisions of L3 balancer, backends, and endpoint sets in namespace
        2) determine which of them are included in current, valid, in-progress and active vectors
        3) add them to the L3 balancer state, so it can be validated

        :type state_handler: l3_balancer.L3BalancerStateHandler
        :type vectors: l3_balancer.
        :type ctx: context.OpCtx
        :param vectors
        :rtype: bool
        """
        ctx = ctx.with_op(op_id=u'discover')

        discovered_vector = l3_balancer.DiscoveredL3BalancerVector.from_cache(self._namespace_id, self._l3_balancer_id)
        ctx.log.debug(u'discovered vector: %s', discovered_vector)

        versions_to_add, versions_to_delete = discovered_vector.find_versions_to_update_in_state(vectors)
        if versions_to_add or versions_to_delete:
            ctx.log.debug(u'versions_to_add: %s, versions_to_delete: %s', versions_to_add, versions_to_delete)
            state_handler.update_versions(
                versions_to_add=versions_to_add,
                versions_to_delete=versions_to_delete)
