class L3ConfigValidationError(Exception):
    def __init__(self, message, cause=None):
        self.cause = cause
        super(L3ConfigValidationError, self).__init__(message)


class L3BalancerTransportError(RuntimeError):
    pass


class UnsupportedParameter(L3BalancerTransportError):
    pass


class RSGroupsConflict(L3BalancerTransportError):
    pass


class VSConfigsConflict(L3BalancerTransportError):
    def __init__(self, message, conflict_pb=None):
        self.conflict_pb = conflict_pb
        super(L3BalancerTransportError, self).__init__(message)
