import logging

from awacs.lib import l3mgrclient
from awacs.lib.eventsreporter import EventsReporter, Event
from awacs.model.l3_balancer import errors
from infra.swatlib import metrics


L3_CTL_REGISTRY = metrics.ROOT_REGISTRY.path(u'l3-ctl')


class L3MgrEvent(object):
    CONFIG_CREATED = u'l3mgr-config-created'
    CONFIG_SKIPPED = u'l3mgr-config-skipped'
    CONFIG_SKIP_IS_NOT_ALLOWED = u'l3mgr-config-skip-is-not-allowed'
    CONFIG_SKIPPED_DUE_TO_TEST_FAIL = u'l3mgr-config-skipped-due-to-test-fail'
    CONFIG_SKIPPED_DUE_TO_VCS_FAIL = u'l3mgr-config-skipped-due-to-vcs-fail'
    CONFIG_SKIPPED_DUE_TO_NOT_FOUND = u'l3mgr-config-skipped-due-to-not-found'
    ERROR = u'l3mgr-error'
    ERROR_RS_GROUPS_CONFLICT = u'l3mgr-rs-groups-conflict'
    ERROR_UNSUPPORTED_PARAM = u'l3mgr-unsupported-parameter'
    ERROR_VS_NOT_SAME = u'l3mgr-error-vs-not-same'


reporter = EventsReporter(events={
    Event(L3MgrEvent.CONFIG_CREATED, log_level=logging.INFO),
    Event(L3MgrEvent.CONFIG_SKIPPED, log_level=logging.INFO),
    Event(L3MgrEvent.CONFIG_SKIP_IS_NOT_ALLOWED, log_level=logging.WARN),
    Event(L3MgrEvent.CONFIG_SKIPPED_DUE_TO_TEST_FAIL, log_level=logging.INFO),
    Event(L3MgrEvent.CONFIG_SKIPPED_DUE_TO_VCS_FAIL, log_level=logging.INFO),
    Event(L3MgrEvent.CONFIG_SKIPPED_DUE_TO_NOT_FOUND, log_level=logging.INFO),
    Event(L3MgrEvent.ERROR, log_level=logging.WARN, associated_exception=l3mgrclient.L3MgrException),
    Event(L3MgrEvent.ERROR_RS_GROUPS_CONFLICT, log_level=logging.WARN, associated_exception=errors.RSGroupsConflict),
    Event(L3MgrEvent.ERROR_UNSUPPORTED_PARAM, log_level=logging.WARN, associated_exception=errors.UnsupportedParameter),
    Event(L3MgrEvent.ERROR_VS_NOT_SAME, log_level=logging.WARN, associated_exception=errors.VSConfigsConflict),
}, metrics_registry=L3_CTL_REGISTRY)
