import six

from awacs.model.l3_balancer.vector import L3BalancerVersion, BackendVersion, EndpointSetVersion


class NamespaceProxy(object):
    __slots__ = ('l3_balancer_pbs', 'backend_pbs', 'endpoint_set_pbs')

    def __init__(self):
        self.l3_balancer_pbs = {}
        self.backend_pbs = {}
        self.endpoint_set_pbs = {}

    def set_l3_balancer_pb(self, l3_balancer_pb):
        self.l3_balancer_pbs[l3_balancer_pb.meta.id] = l3_balancer_pb

    def set_backend_pb(self, backend_pb):
        self.backend_pbs[backend_pb.meta.id] = backend_pb

    def set_endpoint_set_pb(self, endpoint_set_pb):
        self.endpoint_set_pbs[endpoint_set_pb.meta.id] = endpoint_set_pb

    def handle_l3_balancer_update(self, l3_balancer_pb):
        """
        :type l3_balancer_pb: model_pb2.L3Balancer
        """
        self.set_l3_balancer_pb(l3_balancer_pb)

    def handle_l3_balancer_remove(self, l3_balancer_id):
        self.l3_balancer_pbs.pop(l3_balancer_id, None)

    def handle_backend_update(self, backend_pb):
        """
        :type backend_pb: model_pb2.Backend
        """
        self.set_backend_pb(backend_pb)

    def handle_backend_remove(self, backend_id):
        self.backend_pbs.pop(backend_id, None)

    def handle_endpoint_set_update(self, endpoint_set_pb):
        """
        :type endpoint_set_pb: model_pb2.EndpointSet
        """
        self.set_endpoint_set_pb(endpoint_set_pb)

    def handle_endpoint_set_remove(self, endpoint_set_id):
        self.endpoint_set_pbs.pop(endpoint_set_id, None)

    def get_namespace_versions(self):
        l3_balancer_versions = {
            id_: L3BalancerVersion(pb.meta.mtime.ToMicroseconds(), id_, pb.meta.version)
            for id_, pb in six.iteritems(self.l3_balancer_pbs)
        }
        backend_versions = {
            id_: BackendVersion(pb.meta.mtime.ToMicroseconds(), id_, pb.meta.version, pb.spec.deleted)
            for id_, pb in six.iteritems(self.backend_pbs)
        }
        endpoint_set_versions = {
            id_: EndpointSetVersion(pb.meta.mtime.ToMicroseconds(), id_, pb.meta.version, pb.spec.deleted)
            for id_, pb in six.iteritems(self.endpoint_set_pbs)
        }
        return l3_balancer_versions, backend_versions, endpoint_set_versions
