class ValidatorV2(object):
    __slots__ = (u'_namespace_id', u'_l3_balancer_id')

    def __init__(self, namespace_id, l3_balancer_id):
        self._namespace_id = namespace_id
        self._l3_balancer_id = l3_balancer_id

    @staticmethod
    def validate(ctx, state_handler, vectors):
        """
        :type state_handler: l3_balancer.L3BalancerStateHandler
        :type ctx: context.OpCtx
        :param vectors
        """
        ctx = ctx.with_op(op_id=u'validator')
        rollback_counter = vectors.current.transform_until_valid(
            ctx,
            valid_vector=vectors.valid,
            state_handler=state_handler,
        )
        if rollback_counter:
            ctx.log.debug(u'total number of versions that were rolled back: %s', rollback_counter)
