from awacs.model.l7heavy_config.l7heavy_config import DiscoveredL7HeavyConfigVector


class L7HeavyConfigDiscoverer(object):
    @staticmethod
    def discover(ctx, state_handler):
        """
        type state_handler: l7heavy_config.L7HeavyConfigStateHandler
        type ctx: context.OpCtx
        """
        ctx = ctx.with_op(op_id=u'discover')

        discovered_vector = DiscoveredL7HeavyConfigVector.from_cache(*state_handler.full_id)
        vectors = state_handler.generate_vectors()
        ctx.log.debug(u'discovered vector: %s', discovered_vector)
        ctx.log.debug(u'current vector: %s', vectors.current)

        versions_to_add, versions_to_delete = discovered_vector.find_versions_to_update_in_state(vectors)
        if versions_to_add or versions_to_delete:
            if versions_to_add or versions_to_delete:
                ctx.log.debug(u'versions_to_add: %s, versions_to_delete: %s', versions_to_add, versions_to_delete)
            state_handler.update_versions(
                versions_to_add=versions_to_add,
                versions_to_delete=versions_to_delete)
        return vectors

    @staticmethod
    def cleanup_state(ctx, state_handler):
        """
        :type ctx: context.OpCtx
        :type state_handler: l7heavy_config.L7HeavyConfigStateHandler
        """
        ctx = ctx.with_op(op_id=u'cleanup_state')
        valid_vector = state_handler.generate_vectors().valid
        if valid_vector.l7heavy_config_version is None:
            return
        removed_versions = state_handler.remove_obsolete_versions(valid_vector)
        if removed_versions:
            ctx.log.debug(u'removed versions: %s', removed_versions)
