import logging

from awacs.lib import l7heavy_client
from awacs.lib.eventsreporter import EventsReporter, Event
from infra.swatlib import metrics

L7HEAVY_CTL_REGISTRY = metrics.ROOT_REGISTRY.path(u'l7heavy-ctl')


class L7HeavyEvent(object):
    ERROR = u'l7heavy-error'


reporter = EventsReporter(events={
    Event(L7HeavyEvent.ERROR, log_level=logging.WARN, associated_exception=l7heavy_client.L7HeavyError),
}, metrics_registry=L7HEAVY_CTL_REGISTRY)


