from awacs.lib.order_processor.model import has_actionable_spec, is_order_in_progress, needs_removal
from awacs.lib.models.controllers import ModelCtlManager
from awacs.model import objects
from .ctl import L7HeavyConfigCtl
from .order.ctl import L7HeavyConfigOrderCtl


class L7HeavyConfigCtlManager(ModelCtlManager):
    model = objects.L7HeavyConfig

    def should_ctl_be_running(self, full_uid, model, pb=None):
        if not pb:
            return False
        return has_actionable_spec(pb)

    def create_ctl(self, full_uid):
        return L7HeavyConfigCtl(full_uid=full_uid, cache=self.cache)

    def should_restart_ctl(self, full_uid, model, pb=None):
        return False


class L7HeavyConfigOrderCtlManager(ModelCtlManager):
    model = objects.L7HeavyConfig

    def should_ctl_be_running(self, full_uid, model, pb=None):
        if not pb:
            return False
        return is_order_in_progress(pb) and not needs_removal(pb)

    def create_ctl(self, full_uid):
        return L7HeavyConfigOrderCtl(full_uid=full_uid, cache=self.cache, order=True)

    def should_restart_ctl(self, full_uid, model, pb=None):
        return False
