from awacs.lib.order_processor.model import is_spec_complete, needs_removal
from awacs.lib.order_processor.runner import StateRunner
from awacs.lib.models.controllers import ModelCtl, Subscription
from awacs.model import objects
from awacs.model.l7heavy_config.order.processors import L7HeavyConfigOrder


class L7HeavyConfigOrderCtl(ModelCtl):
    model = objects.L7HeavyConfig
    subscriptions = {
        objects.L7HeavyConfig: Subscription(immediate=True)
    }

    runner = StateRunner(
        entity_class=L7HeavyConfigOrder,
        initial_state=L7HeavyConfigOrder.states.STARTED,
        final_state=L7HeavyConfigOrder.states.FINISHED,
        final_cancelled_state=L7HeavyConfigOrder.states.CANCELLED,
        processors=L7HeavyConfigOrder.get_processors(),
        processing_interval=3
    )

    def should_process(self, full_uid, model, pb):
        return not is_spec_complete(pb)

    def process(self, ctx):
        """
        :type ctx: context.OpCtx
        """
        pb = objects.L7HeavyConfig.cache.must_get(*self.full_uid)
        if needs_removal(pb):
            return self._self_delete(ctx, pb)
        return self.runner.process(ctx, pb)

    @staticmethod
    def _self_delete(ctx, pb):
        """
        :type ctx: context.OpCtx
        :type pb: model_pb2.L7HeavyConfig
        """
        ctx.log.info(u'started self deletion')
        objects.L7HeavyConfig.remove(pb.meta.namespace_id, pb.meta.id)
