from awacs.model.l7heavy_config import l7heavy_config


class L7HeavyConfigValidator(object):
    @staticmethod
    def validate(ctx, state_handler):
        """
        :type state_handler: l7heavy_config.L7HeavyConfigStateHandler
        :type ctx: context.OpCtx
        """
        ctx = ctx.with_op(op_id='validator')
        vectors = state_handler.generate_vectors()
        rollback_counter = vectors.current.transform_until_valid(
            ctx,
            valid_vector=vectors.valid,
            state_handler=state_handler,
        )
        if rollback_counter:
            ctx.log.debug(u'total number of versions that were rolled back: %s', rollback_counter)
