from infra.awacs.proto import model_pb2


def announce_template(prj, ctypes, geo, dc=None):
    """
    :type prj: six.text_type
    :type ctypes: set[six.text_type]
    :type geo: six.text_type
    """
    if len(ctypes) > 1:
        ctype_tag = '[ {} ]'.format(' '.join('I@a_ctype_{}'.format(c) for c in sorted(ctypes)))
    else:
        ctype_tag = 'I@a_ctype_{}'.format(list(ctypes)[0])

    filter = 'I@a_itype_balancer . I@a_prj_{} . {} . I@a_geo_{}'.format(prj, ctype_tag, geo)
    if dc is not None and geo != dc:
        filter += ' . I@a_dc_{}'.format(dc)

    return {
        'filter': filter,
        'responsible': ['robot-searchmon'],
        'ruchkas': ['service_balancer_off']
    }


def announce_template_v2(service_ids):
    """
    :type service_ids: list[six.text_type]
    """
    return {
        'filter': ' '.join(['f@{}'.format(service_id) for service_id in sorted(service_ids)]),
        'responsible': ['robot-searchmon'],
        'ruchkas': ['service_balancer_off']
    }


def fill_common_knobs(content, prj, ctypes, geos, knob_pbs, groups, logins):
    """
    :type content: dict
    :type prj: six.text_type
    :type ctypes: set[six.text_type]
    :type geos: set[six.text_type]
    :type knob_pbs: list[model_pb2.NamespaceSpec.ItsSettings.Knobs.KnobSpec]
    :type groups: list[six.text_type]
    :type logins: list[six.text_type]
    """
    node = {
        'responsible': ['robot-searchmon'],
        'ruchkas': list(sorted(knob.its_ruchka_id for knob in knob_pbs)),
        'filter': 'I@a_itype_balancer . I@a_prj_{} . [{}] . [{}]'.format(
            prj,
            ' '.join(['I@a_ctype_{}'.format(ctype) for ctype in sorted(ctypes)]),
            ' '.join(['I@a_geo_{}'.format(geo) for geo in sorted(geos)])
        ),
    }
    if groups or logins:
        node['managers'] = {'logins': logins, 'groups': groups}
    content['groups'].setdefault('common', {'groups': {}})
    content['groups']['common']['groups']['common'] = node


def fill_common_knobs_v2(content, knob_pbs, groups, logins, service_ids):
    """
    :type content: dict
    :type knob_pbs: list[model_pb2.NamespaceSpec.ItsSettings.Knobs.KnobSpec]
    :type groups: list[six.text_type]
    :type service_ids: list[six.text_type]
    :type logins: list[six.text_type]
    """
    node = {
        'responsible': ['robot-searchmon'],
        'ruchkas': list(sorted(knob.its_ruchka_id for knob in knob_pbs)),
        'filter': ' '.join(['f@{}'.format(service_id) for service_id in sorted(service_ids)])
    }
    if groups:
        node['managers'] = {'logins': logins, 'groups': groups}
    content['groups'].setdefault('common', {'groups': {}})
    content['groups']['common']['groups']['common'] = node


def fill_balancer_knobs(content, summary, knob_pbs, split_msk, groups, logins):
    """
    :type content: dict
    :type summary: model.namespace.its_processor.BalancerSummary
    :type knob_pbs: list[model_pb2.NamespaceSpec.ItsSettings.Knobs.KnobSpec]
    :type split_msk: bool
    :type groups: list[six.text_type]
    :type logins: list[six.text_type]
    """
    f = 'I@a_itype_balancer . I@a_prj_{} . I@a_ctype_{} . I@a_geo_{}'.format(summary.prj, summary.ctype, summary.geo)
    if split_msk and summary.dc in ('myt', 'iva'):
        f += ' . I@a_dc_{}'.format(summary.dc)

    node = {
        'responsible': ['robot-searchmon'],
        'ruchkas': list(sorted(knob.its_ruchka_id for knob in knob_pbs)),
        'filter': f
    }
    if groups or logins:
        node['managers'] = {'logins': logins, 'groups': groups}

    geo_or_dc = summary.dc if split_msk else summary.geo
    section_key = '{}-prestable'.format(geo_or_dc) if summary.env_type == model_pb2.BalancerSpec.L7_ENV_PRESTABLE else geo_or_dc
    content['groups'].setdefault(geo_or_dc, {'groups': {}})
    content['groups'][geo_or_dc]['groups'][section_key] = node


def fill_balancer_knobs_v2(content , knob_pbs, groups, logins, env_type, geo_or_dc, service_ids):
    """
    :type content: dict
    :type knob_pbs: list[model_pb2.NamespaceSpec.ItsSettings.Knobs.KnobSpec]
    :type groups: list[six.text_type]
    :type logins: list[six.text_type]
    :type env_type: model_pb2.BalancerSpec.
    :type geo_or_dc: six.text_type
    :type service_ids: list[six.text_type]
    """
    node = {
        'responsible': ['robot-searchmon'],
        'ruchkas': list(sorted(knob.its_ruchka_id for knob in knob_pbs)),
        'filter': ' '.join(['f@{}'.format(service_id) for service_id in sorted(service_ids)])
    }
    if groups:
        node['managers'] = {'logins': logins, 'groups': groups}

    section_key = '{}-prestable'.format(geo_or_dc) if env_type == model_pb2.BalancerSpec.L7_ENV_PRESTABLE else geo_or_dc
    content['groups'].setdefault(geo_or_dc, {'groups': {}})
    content['groups'][geo_or_dc]['groups'][section_key] = node
