"""
This is a temporary module. For now, we only implement descriptors for all objects, so we can construct cache structures
These descriptors should later be moved into individual modules, one per object.
"""

from awacs.lib.models.classes import ZkNodeType, Descriptor, IncludeInDaemons
from awacs.model import codecs
from infra.awacs.proto import model_pb2


class NamespaceDescriptor(Descriptor):
    proto_class = model_pb2.Namespace
    codec_class = codecs.GenerationCodec
    zk_prefix = u'namespaces'
    zk_node_type = ZkNodeType.SINGLE_NESTED
    include_in_daemons = IncludeInDaemons.ALL


class NamespaceAspectSetDescriptor(Descriptor):
    proto_class = model_pb2.NamespaceAspectsSet
    codec_class = codecs.GenerationCodec
    zk_prefix = u'namespace_aspects_sets'
    zk_node_type = ZkNodeType.SINGLE_NESTED
    include_in_daemons = IncludeInDaemons.NOWHERE


class L3BalancerDescriptor(Descriptor):
    proto_class = model_pb2.L3Balancer
    codec_class = codecs.GenerationCodec
    zk_prefix = u'l3_balancers'
    zk_node_type = ZkNodeType.DOUBLE_NESTED
    include_in_daemons = IncludeInDaemons.ALL


class L3BalancerStateDescriptor(Descriptor):
    proto_class = model_pb2.L3BalancerState
    codec_class = codecs.StateGenerationCodec
    zk_prefix = u'l3_balancer_states'
    zk_node_type = ZkNodeType.DOUBLE_NESTED
    include_in_daemons = IncludeInDaemons.ALL_EXCEPT_STATUS


class L7BalancerDescriptor(Descriptor):
    proto_class = model_pb2.Balancer
    codec_class = codecs.GenerationCodec
    # "balancers_2" should be called "balancers", suffix "_2" was introduced during data migration.
    # removing it will most likely require some downtime, so keep it as is for now
    zk_prefix = u'balancers_2'
    zk_node_type = ZkNodeType.DOUBLE_NESTED
    include_in_daemons = IncludeInDaemons.ALL


class L7BalancerStateDescriptor(Descriptor):
    proto_class = model_pb2.BalancerState
    codec_class = codecs.StateGenerationCodec
    # "balancer_states_2" should be called "balancer_states", suffix "_2" was introduced during data migration.
    # removing it will most likely require some downtime, so keep it as is for now
    zk_prefix = u'balancer_states_2'
    zk_node_type = ZkNodeType.DOUBLE_NESTED
    include_in_daemons = IncludeInDaemons.ALL_EXCEPT_STATUS


class L7BalancerAspectSetDescriptor(Descriptor):
    proto_class = model_pb2.BalancerAspectsSet
    codec_class = codecs.GenerationCodec
    zk_prefix = u'balancer_aspects_sets'
    zk_node_type = ZkNodeType.DOUBLE_NESTED
    include_in_daemons = IncludeInDaemons.NOWHERE


class L7BalancerOperationDescriptor(Descriptor):
    proto_class = model_pb2.BalancerOperation
    codec_class = codecs.GenerationCodec
    zk_prefix = u'balancer_operations'
    zk_node_type = ZkNodeType.DOUBLE_NESTED
    include_in_daemons = IncludeInDaemons.ALL_EXCEPT_RESOLVER


class DnsRecordDescriptor(Descriptor):
    proto_class = model_pb2.DnsRecord
    codec_class = codecs.GenerationCodec
    zk_prefix = u'dns_records'
    zk_node_type = ZkNodeType.DOUBLE_NESTED
    include_in_daemons = IncludeInDaemons.ALL


class DnsRecordStateDescriptor(Descriptor):
    proto_class = model_pb2.DnsRecordState
    codec_class = codecs.StateGenerationCodec
    zk_prefix = u'dns_record_states'
    zk_node_type = ZkNodeType.DOUBLE_NESTED
    include_in_daemons = IncludeInDaemons.ALL_EXCEPT_STATUS


class DnsRecordOperationDescriptor(Descriptor):
    proto_class = model_pb2.DnsRecordOperation
    codec_class = codecs.GenerationCodec
    zk_prefix = u'dns_record_operations'
    zk_node_type = ZkNodeType.DOUBLE_NESTED
    include_in_daemons = IncludeInDaemons.ALL_EXCEPT_RESOLVER


class CertDescriptor(Descriptor):
    proto_class = model_pb2.Certificate
    codec_class = codecs.GenerationCodec
    zk_prefix = u'certs'
    zk_node_type = ZkNodeType.DOUBLE_NESTED
    include_in_daemons = IncludeInDaemons.ALL_EXCEPT_RESOLVER


class CertRenewalDescriptor(Descriptor):
    proto_class = model_pb2.CertificateRenewal
    codec_class = codecs.GenerationCodec
    zk_prefix = u'cert_renewals'
    zk_node_type = ZkNodeType.DOUBLE_NESTED
    include_in_daemons = IncludeInDaemons.ALL_EXCEPT_RESOLVER


class KnobDescriptor(Descriptor):
    proto_class = model_pb2.Knob
    codec_class = codecs.GenerationCodec
    zk_prefix = u'knobs'
    zk_node_type = ZkNodeType.DOUBLE_NESTED
    include_in_daemons = IncludeInDaemons.ONLY_WORKER


class ComponentDescriptor(Descriptor):
    proto_class = model_pb2.Component
    codec_class = codecs.GenerationCodec
    zk_prefix = u'components'
    zk_node_type = ZkNodeType.DOUBLE_NESTED  # /<component_type>/<version>
    include_in_daemons = IncludeInDaemons.ONLY_WORKER


class BackendDescriptor(Descriptor):
    proto_class = model_pb2.Backend
    codec_class = codecs.GenerationCodec
    zk_prefix = u'backends'
    zk_node_type = ZkNodeType.DOUBLE_NESTED
    include_in_daemons = IncludeInDaemons.ALL


class EndpointSetDescriptor(Descriptor):
    proto_class = model_pb2.EndpointSet
    codec_class = codecs.GenerationCodec
    zk_prefix = u'endpoint_sets'
    zk_node_type = ZkNodeType.DOUBLE_NESTED
    include_in_daemons = IncludeInDaemons.ALL_EXCEPT_STATUS


class DomainDescriptor(Descriptor):
    proto_class = model_pb2.Domain
    codec_class = codecs.GenerationCodec
    zk_prefix = u'domains'
    zk_node_type = ZkNodeType.DOUBLE_NESTED
    include_in_daemons = IncludeInDaemons.ALL_EXCEPT_RESOLVER


class DomainOperationDescriptor(Descriptor):
    proto_class = model_pb2.DomainOperation
    codec_class = codecs.GenerationCodec
    zk_prefix = u'domain_operations'
    zk_node_type = ZkNodeType.DOUBLE_NESTED
    include_in_daemons = IncludeInDaemons.ALL_EXCEPT_RESOLVER


class UpstreamDescriptor(Descriptor):
    proto_class = model_pb2.Upstream
    codec_class = codecs.GenerationCodec
    zk_prefix = u'upstreams'
    zk_node_type = ZkNodeType.DOUBLE_NESTED
    include_in_daemons = IncludeInDaemons.ONLY_WORKER


class NameServerDescriptor(Descriptor):
    proto_class = model_pb2.NameServer
    codec_class = codecs.GenerationCodec
    zk_prefix = u'name_servers'
    zk_node_type = ZkNodeType.DOUBLE_NESTED
    include_in_daemons = IncludeInDaemons.ONLY_WORKER
