# coding: utf-8
from infra.swatlib.gevent.exclusiveservice2 import ExclusiveService
from infra.swatlib.zk.treecache import DataNode, SkippedNode, RootStructure

from awacs.model import codecs


# NOTE: Actually nodes "balancers_2" and "balancer_states_2" should be called
# "balancers" and "balancer_states" correspondingly.
# Suffix _2 was introduced during data migration. Let's live with it for now,
# as removing it most likely will require some downtime.
BALANCERS_NODE = 'balancers_2'
BALANCER_STATES_NODE = 'balancer_states_2'
BALANCER_ASPECTS_SET_NODE = 'balancer_aspects_sets'
NAMESPACES_NODE = 'namespaces'
NAMESPACE_ASPECTS_SET_NODE = 'namespace_aspects_sets'
COMPONENTS_NODE = 'components'
KNOBS_NODE = 'knobs'
CERTS_NODE = 'certs'
CERT_RENEWALS_NODE = 'cert_renewals'
L3_BALANCERS_NODE = 'l3_balancers'
L3_BALANCER_STATES_NODE = 'l3_balancer_states'
DNS_RECORDS_NODE = 'dns_records'
DNS_RECORD_OPERATIONS_NODE = 'dns_record_operations'
DNS_RECORD_STATES_NODE = 'dns_record_states'
NAME_SERVERS_NODE = 'name_servers'
BACKENDS_NODE = 'backends'
ENDPOINT_SETS_NODE = 'endpoint_sets'
UPSTREAMS_NODE = 'upstreams'
DOMAINS_NODE = 'domains'
DOMAIN_OPERATIONS_NODE = 'domain_operations'
BALANCER_OPERATIONS_NODE = 'balancer_operations'
EXCLUSIVE_SERVICES_NODE = ExclusiveService.ZK_PATH.strip('/')
PARTIES_NODE = 'parties'

ZK_STRUCTURE_DATA = {
    NAMESPACES_NODE: SkippedNode(  # namespace id
        DataNode(codecs.NamespaceCodec)  # pb
    ),
    COMPONENTS_NODE: SkippedNode(  # component type
        SkippedNode(  # component version
            DataNode(codecs.ComponentCodec)  # pb
        )
    ),
    KNOBS_NODE: SkippedNode(  # namespace id
        SkippedNode(  # knob id
            DataNode(codecs.KnobCodec)  # pb
        )
    ),
    CERTS_NODE: SkippedNode(  # namespace id
        SkippedNode(  # certificate id
            DataNode(codecs.CertificateCodec)  # pb
        )
    ),
    CERT_RENEWALS_NODE: SkippedNode(  # namespace id
        SkippedNode(  # certificate id
            DataNode(codecs.CertificateRenewalCodec)  # pb
        )
    ),
    BALANCERS_NODE: SkippedNode(  # namespace id
        SkippedNode(  # balancer id
            DataNode(codecs.BalancerCodec)  # pb
        )
    ),
    L3_BALANCERS_NODE: SkippedNode(  # namespace id
        SkippedNode(  # l3 balancer id
            DataNode(codecs.L3BalancerCodec)  # pb
        )
    ),
    DNS_RECORDS_NODE: SkippedNode(  # namespace id
        SkippedNode(  # dns record id
            DataNode(codecs.DnsRecordCodec)  # pb
        )
    ),
    DNS_RECORD_OPERATIONS_NODE: SkippedNode(  # namespace id
        SkippedNode(  # dns record id
            DataNode(codecs.DnsRecordOperationCodec)  # pb
        )
    ),
    NAME_SERVERS_NODE: SkippedNode(  # namespace id
        SkippedNode(  # name server id
            DataNode(codecs.NameServerCodec)  # pb
        )
    ),
    BACKENDS_NODE: SkippedNode(  # namespace id
        SkippedNode(  # backend id
            DataNode(codecs.BackendCodec)  # pb
        )
    ),
    ENDPOINT_SETS_NODE: SkippedNode(  # namespace id
        SkippedNode(  # endpoint set id
            DataNode(codecs.EndpointSetCodec)  # pb
        )
    ),
    BALANCER_STATES_NODE: SkippedNode(  # namespace id
        SkippedNode(  # balancer state id
            DataNode(codecs.BalancerStateCodec)  # pb
        )
    ),
    L3_BALANCER_STATES_NODE: SkippedNode(  # namespace id
        SkippedNode(  # l3 balancer state id
            DataNode(codecs.L3BalancerStateCodec)  # pb
        )
    ),
    DNS_RECORD_STATES_NODE: SkippedNode(  # namespace id
        SkippedNode(  # l3 balancer state id
            DataNode(codecs.DnsRecordStateCodec)  # pb
        )
    ),
    UPSTREAMS_NODE: SkippedNode(  # namespace id
        SkippedNode(  # upstream id
            DataNode(codecs.UpstreamCodec)  # pb
        )
    ),
    DOMAINS_NODE: SkippedNode(  # namespace id
        SkippedNode(  # domain id
            DataNode(codecs.DomainCodec)  # pb
        )
    ),
    DOMAIN_OPERATIONS_NODE: SkippedNode(  # namespace id
        SkippedNode(  # domain operation id
            DataNode(codecs.DomainOperationCodec)  # pb
        )
    ),
    BALANCER_OPERATIONS_NODE: SkippedNode(  # namespace id
        SkippedNode(  # balancer operation id
            DataNode(codecs.BalancerOperationCodec)  # pb
        )
    ),
    BALANCER_ASPECTS_SET_NODE: SkippedNode(  # namespace id
        SkippedNode(  # balancer id
            DataNode(codecs.BalancerAspectsSetCodec)  # pb
        )
    ),
    NAMESPACE_ASPECTS_SET_NODE: SkippedNode(  # namespace id
        DataNode(codecs.NamespaceAspectsSetCodec)  # pb
    ),
    PARTIES_NODE: SkippedNode(
        SkippedNode(
            DataNode()  # process name, no codec
        )
    ),
}

ZK_STRUCTURE = RootStructure(ZK_STRUCTURE_DATA)


def construct_awacsworkerd_zk_structure():
    data = dict(ZK_STRUCTURE_DATA)
    for node in [
        NAMESPACE_ASPECTS_SET_NODE,
        BALANCER_ASPECTS_SET_NODE,
    ]:
        del data[node]
    return RootStructure(data)


AWACSWORKERD_ZK_STRUCTURE = construct_awacsworkerd_zk_structure()


def construct_awacsresolverd_zk_structure():
    data = {}
    for node in [
        PARTIES_NODE,
        NAMESPACES_NODE,
        BALANCERS_NODE, BALANCER_STATES_NODE,
        L3_BALANCERS_NODE, L3_BALANCER_STATES_NODE,
        DNS_RECORDS_NODE, DNS_RECORD_STATES_NODE,
        BACKENDS_NODE,
        ENDPOINT_SETS_NODE,
    ]:
        data[node] = ZK_STRUCTURE_DATA[node]
    return RootStructure(data)


AWACSRESOLVERD_ZK_STRUCTURE = construct_awacsresolverd_zk_structure()


def construct_awacsstatusd_zk_structure():
    data = {
        EXCLUSIVE_SERVICES_NODE: SkippedNode(  # exclusive service name
            SkippedNode(  # lock node
                DataNode()  # contender name
            )
        ),
    }
    for node in [
        PARTIES_NODE,
        # awacsstatusd should also watch everything that can have running ctl
        # in order to be able to filter out locks for gone objects
        BALANCERS_NODE,
        BALANCER_OPERATIONS_NODE,
        NAMESPACES_NODE,
        CERTS_NODE,
        CERT_RENEWALS_NODE,
        L3_BALANCERS_NODE,
        DNS_RECORDS_NODE,
        BACKENDS_NODE,
        DOMAINS_NODE,
        DOMAIN_OPERATIONS_NODE,
        DNS_RECORD_OPERATIONS_NODE,
    ]:
        data[node] = ZK_STRUCTURE_DATA[node]
    return RootStructure(data)


AWACSSTATUSD_ZK_STRUCTURE = construct_awacsstatusd_zk_structure()


def fmt_namespace_zk_path(id_):
    return id_


def fmt_namespace_aspects_set_zk_path(id_):
    return id_


def fmt_knob_zk_path(namespace_id, id_):
    return '{}/{}'.format(namespace_id, id_)


def fmt_knobs_zk_path(namespace_id):
    return namespace_id


def fmt_cert_renewal_zk_path(namespace_id, id_):
    return '{}/{}'.format(namespace_id, id_)


def fmt_cert_zk_path(namespace_id, id_):
    return '{}/{}'.format(namespace_id, id_)


def fmt_certs_zk_path(namespace_id):
    return namespace_id


def fmt_dns_record_zk_path(namespace_id, id_):
    return '{}/{}'.format(namespace_id, id_)


def fmt_dns_records_zk_path(namespace_id):
    return namespace_id


def fmt_dns_record_op_zk_path(namespace_id, id_):
    return '{}/{}'.format(namespace_id, id_)


def fmt_dns_record_ops_zk_path(namespace_id):
    return namespace_id


def fmt_dns_record_state_zk_path(namespace_id, id_):
    return '{}/{}'.format(namespace_id, id_)


def fmt_dns_record_states_zk_path(namespace_id):
    return namespace_id


def fmt_name_server_zk_path(namespace_id, id_):
    return '{}/{}'.format(namespace_id, id_)


def fmt_name_servers_zk_path(namespace_id):
    return namespace_id


def fmt_l3_balancer_zk_path(namespace_id, id_):
    return '{}/{}'.format(namespace_id, id_)


def fmt_l3_balancers_zk_path(namespace_id):
    return namespace_id


def fmt_l3_balancer_state_zk_path(namespace_id, id_):
    return '{}/{}'.format(namespace_id, id_)


def fmt_l3_balancer_states_zk_path(namespace_id):
    return namespace_id


def fmt_balancer_zk_path(namespace_id, id_):
    return '{}/{}'.format(namespace_id, id_)


def fmt_balancers_zk_path(namespace_id):
    return namespace_id


def fmt_balancer_state_zk_path(namespace_id, id_):
    return '{}/{}'.format(namespace_id, id_)


def fmt_balancer_states_zk_path(namespace_id):
    return namespace_id


def fmt_balancer_aspects_set_zk_path(namespace_id, id_):
    return '{}/{}'.format(namespace_id, id_)


def fmt_balancer_aspects_sets_zk_path(namespace_id):
    return namespace_id


def fmt_upstream_zk_path(namespace_id, id_):
    return '{}/{}'.format(namespace_id, id_)


def fmt_upstreams_zk_path(namespace_id):
    return namespace_id


def fmt_domain_zk_path(namespace_id, id_):
    return '{}/{}'.format(namespace_id, id_)


def fmt_domains_zk_path(namespace_id):
    return namespace_id


def fmt_domain_operation_zk_path(namespace_id, id_):
    return '{}/{}'.format(namespace_id, id_)


def fmt_domain_operations_zk_path(namespace_id):
    return namespace_id


def fmt_balancer_operation_zk_path(namespace_id, id_):
    return '{}/{}'.format(namespace_id, id_)


def fmt_balancer_operations_zk_path(namespace_id):
    return namespace_id


def fmt_backend_zk_path(namespace_id, id_):
    return '{}/{}'.format(namespace_id, id_)


def fmt_backends_zk_path(namespace_id):
    return namespace_id


def fmt_endpoint_set_zk_path(namespace_id, id_):
    return '{}/{}'.format(namespace_id, id_)


def fmt_endpoint_sets_zk_path(namespace_id):
    return namespace_id


def fmt_component_zk_path(id_, version):
    return '{}/{}'.format(id_, version)
