from awacs.lib.models.classes import get_all_descriptors, AwacsDaemon
from infra.swatlib.gevent.exclusiveservice2 import ExclusiveService
from infra.swatlib.zk.treecache import DataNode, SkippedNode, RootStructure


EXCLUSIVE_SERVICES_NODE_ZK_PREFIX = ExclusiveService.ZK_PATH.strip(u'/')
PARTIES_NODE_ZK_PREFIX = u'parties'

parties_node = {
    PARTIES_NODE_ZK_PREFIX: SkippedNode(
        SkippedNode(
            DataNode()  # process name, no codec
        ),
    ),
}
exclusive_services_node = {
    EXCLUSIVE_SERVICES_NODE_ZK_PREFIX: SkippedNode(  # exclusive service name
        SkippedNode(  # lock node
            DataNode()  # contender name
        ),
    ),
}


def _construct_zk_structure(daemon=None, include_parties_node=True, include_exclusive_services_node=True):
    data = {}
    if include_parties_node:
        data.update(parties_node)
    if include_exclusive_services_node:
        data.update(exclusive_services_node)
    for descriptor in get_all_descriptors():
        if daemon is not None and daemon not in descriptor.include_in_daemons:
            continue
        if descriptor.zk_prefix in data:
            raise RuntimeError(u'Duplicated zk_prefix="{}" in descriptor "{}"'.format(descriptor.zk_prefix,
                                                                                      descriptor.__name__))
        data[descriptor.zk_prefix] = descriptor.get_cache_structure()
    return RootStructure(data)


def construct_full_zk_structure():
    return _construct_zk_structure(daemon=None,
                                   include_parties_node=True,
                                   include_exclusive_services_node=False)


def construct_awacsworkerd_zk_structure():
    return _construct_zk_structure(daemon=AwacsDaemon.WORKER,
                                   include_parties_node=True,
                                   include_exclusive_services_node=False)


def construct_awacsresolverd_zk_structure():
    return _construct_zk_structure(daemon=AwacsDaemon.RESOLVER,
                                   include_parties_node=True,
                                   include_exclusive_services_node=False)


def construct_awacsstatusd_zk_structure():
    return _construct_zk_structure(daemon=AwacsDaemon.STATUS,
                                   include_parties_node=True,
                                   include_exclusive_services_node=True)
