# coding: utf-8
import re
import six

from infra.awacs.proto import internals_pb2
from ..util import strip_host_domain


def _get_gencfg_group_release(item):
    name_version_use_mtn_tuple, instance_pbs = item
    # Хачный способ сравнения имён релизов gencfg: обычное сравнение строк не работает, например,
    # tags/stable-1-r1 и tags/prestable-9-r1
    version = re.findall(r'^tags/[0-9a-zA-Z\-\.]+-(\d+)-r(\d+)$', name_version_use_mtn_tuple[1])
    return name_version_use_mtn_tuple[1] == 'trunk', version


def merge_gencfg_group_instances(gencfg_group_instances):
    """
    :type gencfg_group_instances: list[tuple[six.text_type, six.text_type], list[internals_pb2.Instance]]
    :rtype: list[internals_pb2.Instance]
    """
    instances = {}
    for gencfg_group, instance_pbs in sorted(gencfg_group_instances, key=_get_gencfg_group_release):
        for instance_pb in instance_pbs:  # type: internals_pb2.Instance
            # У нас есть хосты, с которыми связаны сразу две записи: ws1-111.yandex.ru и ws1-111.search.yandex.net
            # В разных версиях топологии gencfg один и тот же хост может быть записан двумя разными способами
            # Скрестим пальцы и будем считать, что для двух таких записей речь идёт об одном хосте.
            # Выкинем запись, полученную из старой топологии, и возьмём запись из новой.
            host_and_port = (strip_host_domain(instance_pb.host), instance_pb.port)
            instances[host_and_port] = instance_pb
    return list(six.itervalues(instances))
