# coding: utf-8
import six

from infra.awacs.proto import internals_pb2
from ..util import strip_host_domain


def merge_nanny_snapshot_instances(nanny_snapshot_instances):
    """
    :type nanny_snapshot_instances: list[tuple[six.text_type, six.text_type], list[internals_pb2.Instance]]
    :rtype: list[internals_pb2.Instance]
    """
    # TODO: order snapshots by ctime as we order gencfg groups by their version?
    instances = {}
    for (service_id, snapshot_id), instance_pbs in nanny_snapshot_instances:
        for instance_pb in instance_pbs:  # type: internals_pb2.Instance
            host_and_port = (strip_host_domain(instance_pb.host), instance_pb.port)
            instances[host_and_port] = instance_pb
    return list(six.itervalues(instances))
