# coding: utf-8
import inject

from sepelib.yandex import oauth

from awacs.lib import rpc
from infra.awacs.proto import api_pb2
from .util import AwacsBlueprint


oauth_service_bp = AwacsBlueprint('rpc_oauth_service', __name__, '/api')


@oauth_service_bp.method('GetOauthToken',
                         request_type=api_pb2.GetOauthTokenRequest,
                         response_type=api_pb2.GetOauthTokenResponse)
def get_oauth_token(req_pb, auth_subject):
    if req_pb.error:
        raise rpc.exceptions.BadRequestError('OAuth server returned error: {}'.format(req_pb.error))

    oauth_client = inject.instance(oauth.IOAuth)
    if req_pb.code:
        token = oauth_client.get_token_by_authorization_code(req_pb.code)
        return api_pb2.GetOauthTokenResponse(
            token=token.content,
            expires_in=token.expires_in if token.expires_in else -1)
    else:
        flask_resp = oauth_client.redirect_to_authorize_page()
        return api_pb2.GetOauthTokenResponse(
            redirect_url=flask_resp.location)
