from infra.swatlib import webserver, metrics


class AwacsWebServer(webserver.WebServer):
    def __init__(self, cfg, app, version, instance_id=None, certfile=None):
        max_in_flight = cfg['web']['http'].get('max_in_flight', 0)
        if max_in_flight:
            app.wsgi_app = webserver.CapacityLimiter(app.wsgi_app,
                                                     max_in_flight=max_in_flight,
                                                     headers=[
                                                         ('X-Instance-Id', str(instance_id)),
                                                     ],
                                                     registry=metrics.ROOT_REGISTRY.path('capacity-limiter'))
        super(AwacsWebServer, self).__init__(cfg, app, version, certfile=certfile)
