function renderNamespacesStatistics() {
    var x = ['x'];
    var sre = ['sre'];
    var users = ['users'];
    var i = 1;
    var tooltips = {};
    NAMESPACES_STATISTICS_DATA.forEach(function (point) {
        if (point.namespace_id === 'translate-internal.yandex.net' || point.namespace_id === 'yappy.yandex.ru') {
            return; // it's too large and stretches the graph
        }
        var id = i++;
        x.push(id);
        tooltips[id] = point.namespace_id + ', создан ' + point.ctime.split('T')[0];
        if (point.sre_edits === 0 && point.user_edits === 0) {
            point.user_edits++; // just to show a small bar
        }
        if (!point.ordered) {
            sre.push(-point.sre_edits);
            users.push(-point.user_edits);
        } else {
            sre.push(point.sre_edits);
            users.push(point.user_edits);
        }
    });

    c3.generate({
        bindto: '#namespaces-statistics-graph',
        data: {
            x: 'x',
            columns: [
                x,
                sre,
                users
            ],
            type: 'bar',
            groups: [
                ['sre', 'users']
            ],
            names: {
                sre: 'Правки SRE',
                users: 'Правки пользователей'
            },
            colors: {
                sre: '#c97a77',
                users: '#78afdd'
            }
        },
        axis: {
            /*y: {
                max: 40,
                min: -40,
                // Range includes padding, set 0 if no padding needed
                // padding: {top:0, bottom:0}
            }*/
        },
        labels: true,
        bar: {
            width: {
                ratio: 0.8
            }
        },
        tooltip: {
            format: {
                title: function (d) {
                    return tooltips[d];
                }
            }
        }
    });
}


function renderL3BalancersStatistics(options) {
    options = options || {};
    if (options.minCtime) {
        options.minCtime = new Date(options.minCtime).getTime();
    }
    if (options.maxCtime) {
        options.maxCtime = new Date(options.maxCtime).getTime();
    }
    var x = ['x'];
    var sre = ['sre'];
    var users = ['users'];
    var i = 1;
    var tooltips = {};
    L3_BALANCERS_STATISTICS_DATA.forEach(function (point) {
        var ctime = new Date(point.ctime).getTime();
        if (options.minCtime && ctime < options.minCtime) {
            return;
        }
        if (options.maxCtime && ctime > options.maxCtime) {
            return;
        }
        var id = i++;
        tooltips[id] = point.id + ', created ' + point.ctime;
        x.push(id);
        if (point.created_by_sre) {
            sre.push(point.ordered ? 1 : -1);
            users.push(0);
        } else {
            sre.push(0);
            users.push(point.ordered ? 1 : -1);
        }
    });

    c3.generate({
        bindto: '#l3-balancers-statistics-graph',
        data: {
            x: 'x',
            columns: [
                x,
                sre,
                users
            ],
            type: 'bar',
            groups: [
                ['sre', 'users']
            ],
            names: {
                sre: 'Создан SRE',
                users: 'Создан пользователем'
            },
            colors: {
                sre: '#c97a77',
                users: '#78afdd'
            }
        },
        labels: true,
        axis: {
            y: {
            tick: {
                // this also works for non timeseries data
                values: [-1, 0, 1]
            }
        }
        },
        bar: {
            width: {
            }
        },
        tooltip: {
            format: {
                title: function (d) {
                    return tooltips[d];
                }
            }
        }
    });
}