# coding: utf-8
from awacs.lib.rpc import exceptions
from infra.awacs.proto import api_pb2


def validate_request(req_pb):
    """
    :raises: exceptions.BadRequestError
    """
    if isinstance(req_pb, (api_pb2.GetNamespaceObjectsCountRequest, api_pb2.GetNamespaceUnresolvedEndpointSetsRequest)):
        if not req_pb.id:
            raise exceptions.BadRequestError('"id" must be set')
    elif isinstance(req_pb, api_pb2.GetEasyModeUpstreamIdsForBackendRequest):
        if not req_pb.namespace_id:
            raise exceptions.BadRequestError('"namespace_id" must be set')
        if not req_pb.id:
            raise exceptions.BadRequestError('"id" must be set')
    elif isinstance(req_pb, api_pb2.GetNormalizedInstanceMacroFromBalancerYamlRequest):
        if not req_pb.yaml:
            raise exceptions.BadRequestError('"yaml" must be set')
    elif isinstance(req_pb, api_pb2.GetNormalizedConfigFromUpstreamYamlRequest):
        if req_pb.WhichOneof('input') is None:
            raise exceptions.BadRequestError('"yaml" or "config" must be set')
    elif isinstance(req_pb, api_pb2.GenerateLuaRequest):
        if not req_pb.namespace_id:
            raise exceptions.BadRequestError('"namespace_id" must be set')
        if not req_pb.balancer_id:
            raise exceptions.BadRequestError('"balancer_id" must be set')

        if req_pb.upstream_id:
            if not req_pb.upstream_yaml:
                raise exceptions.BadRequestError('"upstream_yaml" must be set')
        else:
            if not req_pb.balancer_yaml:
                raise exceptions.BadRequestError('"balancer_yaml" must be set')
    elif isinstance(req_pb, api_pb2.ListEasyModeUpstreamWeightSectionsRequest):
        if not req_pb.namespace_id:
            raise exceptions.BadRequestError('"namespace_id" must be set')
