# coding: utf-8
import collections
import six


class Error(Exception):
    pass


class ValidationError(Error):
    def __init__(self, message, field_name=None, hint=None):
        """
        :param hint: version that caused this error
        :type hint: (BalancerVersion | DomainVersion | UpstreamVersion |
                     BackendVersion | EndpointSetVersion | KnobVersion)
        """
        self.message = message
        self.path = collections.deque()
        if field_name is not None:
            self.path.append(field_name)
        self.hint = hint
        super(ValidationError, self).__init__(self, message)

    def __repr__(self):
        return six.text_type(self)

    def __str__(self):
        if self.path:
            return '{}: {}'.format(' -> '.join(self.path), self.message)
        else:
            return six.text_type(self.message)

    __unicode = __str__


class UpstreamDoesNotExist(ValidationError):
    pass


class EndpointSetsDoNotExist(ValidationError):
    def __init__(self, message, full_ids=None, field_name=None):
        self.full_ids = full_ids
        super(EndpointSetsDoNotExist, self).__init__(message, field_name=field_name)


class BackendsDoNotExist(ValidationError):
    def __init__(self, message, full_ids=None, field_name=None):
        self.full_ids = full_ids
        super(BackendsDoNotExist, self).__init__(message, field_name=field_name)


class KnobDoesNotExist(ValidationError):
    def __init__(self, message, full_ids=None, field_name=None):
        self.full_ids = full_ids
        super(KnobDoesNotExist, self).__init__(message, field_name=field_name)


class CertDoesNotExist(ValidationError):
    def __init__(self, message, full_ids=None, field_name=None):
        self.full_ids = full_ids
        super(CertDoesNotExist, self).__init__(message, field_name=field_name)
