from .model import BaseVisitor, UI_TAG


class UpstreamChecker(BaseVisitor):
    RULE = 'ARL'

    def check_Balancer2(self, module, path):
        is_terminal = module.generated_proxy_backends
        if (is_terminal and
                not module.attempts_rate_limiter and
                not module.pb.disable_attempts_rate_limiter.value and
                module.pb.attempts != 1):
            self.warn(path, 'Attempts rate limiter is missing.', tags={UI_TAG, 'no-attempts-rate-limiter'})
