from .model import BaseVisitor


class UpstreamChecker(BaseVisitor):
    RULE = 'ARL'

    def check_Balancer2(self, module, path):
        is_terminal = module.generated_proxy_backends
        policy_kinds = module.balancing_policy and module.balancing_policy.list_policy_kinds() or set()
        uses_wm_policy = 'watermark_policy' in policy_kinds
        if (is_terminal and
                not module.attempts_rate_limiter and
                module.pb.attempts != 1 and
                not uses_wm_policy
                and not module.pb.disable_attempts_rate_limiter.value):
            self.warn(path, 'ATTEMPTS_LIMITER_DISABLED', tags={'no-arl', 'no-wm-policy'})
